/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;

public class MavenExecutionResult {
    private final File basedir;
    private final List<String> log;

    MavenExecutionResult(File basedir, File logFile) throws IOException {
        this.basedir = basedir;
        ArrayList<String> log = new ArrayList<String>();
        if (logFile.canRead()) {
            for (String line : Files.readAllLines(logFile.toPath(), Charset.defaultCharset())) {
                log.add(line);
            }
        }
        this.log = Collections.unmodifiableList(log);
    }

    public MavenExecutionResult assertErrorFreeLog() throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        for (String line : this.log) {
            if (!line.contains("[ERROR]")) continue;
            errors.add(line);
        }
        Assert.assertTrue((String)((Object)errors).toString(), (boolean)errors.isEmpty());
        return this;
    }

    public MavenExecutionResult assertLogText(String text) {
        for (String line : this.log) {
            if (!line.contains(text)) continue;
            return this;
        }
        Assert.fail((String)("Log line not present: " + text));
        return this;
    }

    public MavenExecutionResult assertNoLogText(String text) {
        for (String line : this.log) {
            if (!line.contains(text)) continue;
            Assert.fail((String)("Log line present: " + text));
        }
        return this;
    }

    public File getBasedir() {
        return this.basedir;
    }
}

