/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import io.takari.builder.internal.pathmatcher.PathNormalizer;
import io.takari.builder.internal.pathmatcher.Plexus_MatchPatterns;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;

public class FileMatcher {
    private static final Matcher MATCH_EVERYTHING = new Matcher(){

        @Override
        public boolean matches(String path) {
            return true;
        }
    };
    final Matcher includesMatcher;
    final Matcher excludesMatcher;
    private final String basedir;

    private static Matcher fromStrings(String basepath, Collection<String> globs, Matcher everything) {
        if (globs == null || globs.isEmpty()) {
            return null;
        }
        ArrayList<String> normalized = new ArrayList<String>();
        for (String glob : globs) {
            if ("*".equals(glob) || "**".equals(glob) || "**/*".equals(glob)) {
                return everything;
            }
            StringBuilder gb = new StringBuilder();
            if (!basepath.endsWith("/")) {
                gb.append(basepath).append('/');
            }
            gb.append(glob.startsWith("/") ? glob.substring(1) : glob);
            if (glob.endsWith("/")) {
                gb.append("**");
            }
            normalized.add(gb.toString().replace(File.separatorChar, '/'));
        }
        final Plexus_MatchPatterns matcher = Plexus_MatchPatterns.from(normalized);
        return new Matcher(){

            @Override
            public boolean matches(String path) {
                return matcher.matches(path, false);
            }
        };
    }

    private FileMatcher(String basedir, Matcher includesMatcher, Matcher excludesMatcher) {
        this.basedir = basedir;
        this.includesMatcher = includesMatcher;
        this.excludesMatcher = excludesMatcher;
    }

    public boolean matches(String path) {
        if (this.basedir != null && !path.startsWith(this.basedir)) {
            return false;
        }
        if (this.excludesMatcher != null && this.excludesMatcher.matches(path)) {
            return false;
        }
        if (this.includesMatcher != null) {
            return this.includesMatcher.matches(path);
        }
        return true;
    }

    public boolean matches(Path file) {
        return this.matches(PathNormalizer.normalize0(file));
    }

    public boolean matches(File file) {
        return this.matches(PathNormalizer.normalize0(file.toPath()));
    }

    public static Map<Path, FileMatcher> createMatchers(Path basedir, Collection<String> includes, Collection<String> excludes) {
        String basepath = PathNormalizer.normalize0(basedir);
        if (includes == null || includes.isEmpty()) {
            return Collections.singletonMap(basedir, FileMatcher.createMatcher(basepath, includes, excludes));
        }
        return FileMatcher.createMatchers(basepath, includes, excludes, PathNormalizer::toPath);
    }

    public static Map<String, FileMatcher> createMatchers(Collection<String> includes, Collection<String> excludes) {
        String basepath = "";
        if (includes == null || includes.isEmpty()) {
            return Collections.singletonMap(basepath, FileMatcher.createMatcher(basepath, includes, excludes));
        }
        return FileMatcher.createMatchers(basepath, includes, excludes, Function.identity());
    }

    private static <T> Map<T, FileMatcher> createMatchers(String basepath, Collection<String> includes, Collection<String> excludes, Function<String, T> fromString) {
        Matcher excludesMatcher = FileMatcher.fromStrings(basepath, excludes, MATCH_EVERYTHING);
        HashMap matchers = new HashMap();
        FileMatcher.newIncludesTrie(includes).subdirs().forEach((relpath, globs) -> {
            String path = relpath != null ? String.valueOf(basepath) + "/" + relpath : basepath;
            FileMatcher matcher2 = globs != null ? FileMatcher.createMatcher(path, (Collection<String>)globs, excludesMatcher) : FileMatcher.createSinglePathMatcher(path);
            matchers.put(fromString.apply(path), matcher2);
        });
        return matchers;
    }

    private static Trie newIncludesTrie(Collection<String> includes) {
        Trie root = new Trie();
        block0: for (String include : includes) {
            if (include.endsWith("/")) {
                include = String.valueOf(include) + "**";
            }
            Trie trie = root;
            StringTokenizer st = new StringTokenizer(include, "/");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (name.contains("*") || name.contains("?")) {
                    trie.addIncludes(FileMatcher.subglob(name, st));
                    continue block0;
                }
                trie = trie.child(name);
            }
        }
        return root;
    }

    private static FileMatcher createMatcher(String basedir, Collection<String> includes, Matcher excludesMatcher) {
        Matcher includesMatcher = FileMatcher.fromStrings(basedir, includes, null);
        return new FileMatcher(FileMatcher.toDirectoryPath(basedir), includesMatcher, excludesMatcher);
    }

    private static FileMatcher createSinglePathMatcher(String path) {
        return new FileMatcher(null, new SinglePathMatcher(path), null);
    }

    private static String subglob(String name, StringTokenizer st) {
        StringBuilder glob = new StringBuilder(name);
        while (st.hasMoreTokens()) {
            glob.append('/').append(st.nextToken());
        }
        return glob.toString();
    }

    public static FileMatcher createMatcher(Path basedir, Collection<String> includes, Collection<String> excludes) {
        return FileMatcher.createMatcher(PathNormalizer.normalize0(basedir), includes, excludes);
    }

    public static FileMatcher createMatcher(Collection<String> includes, Collection<String> excludes) {
        return FileMatcher.createMatcher("", includes, excludes);
    }

    private static FileMatcher createMatcher(String basepath, Collection<String> includes, Collection<String> excludes) {
        Matcher includesMatcher = FileMatcher.fromStrings(basepath, includes, null);
        Matcher excludesMatcher = FileMatcher.fromStrings(basepath, excludes, MATCH_EVERYTHING);
        return new FileMatcher(FileMatcher.toDirectoryPath(basepath), includesMatcher, excludesMatcher);
    }

    protected static String toDirectoryPath(String basepath) {
        return basepath.endsWith("/") ? basepath : String.valueOf(basepath) + "/";
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }

    static class SinglePathMatcher
    implements Matcher {
        final String path;

        public SinglePathMatcher(String path) {
            this.path = path;
        }

        @Override
        public boolean matches(String path) {
            return this.path.equals(path);
        }
    }

    static class Trie {
        Map<String, Trie> children;
        Collection<String> includes;

        Trie() {
        }

        public void addIncludes(String glob) {
            if (this.includes == null) {
                this.includes = new LinkedHashSet<String>();
            }
            this.includes.add(glob);
            if (this.children != null) {
                this.children.values().forEach(child -> child.addIncludesTo(this.includes));
                this.children = null;
            }
        }

        private void addIncludesTo(Collection<String> other) {
            if (this.children != null) {
                this.children.values().forEach(child -> child.addIncludesTo(other));
            }
            if (this.includes != null) {
                other.addAll(this.includes);
            }
        }

        public Trie child(String name) {
            Trie child;
            if (this.includes != null) {
                return this;
            }
            if (this.children == null) {
                this.children = new HashMap<String, Trie>();
            }
            if ((child = this.children.get(name)) == null) {
                child = new Trie();
                this.children.put(name, child);
            }
            return child;
        }

        public Map<String, Collection<String>> subdirs() {
            return this.addSubdirs(null, new HashMap<String, Collection<String>>());
        }

        private Map<String, Collection<String>> addSubdirs(String path, Map<String, Collection<String>> subdirs) {
            if (this.children != null) {
                this.children.forEach((name, child) -> {
                    Map<String, Collection<String>> map2 = child.addSubdirs(Trie.childname(path, name), subdirs);
                });
            } else {
                subdirs.put(path, this.includes);
            }
            return subdirs;
        }

        private static String childname(String basedir, String name) {
            return basedir != null ? String.valueOf(basedir) + "/" + name : name;
        }
    }
}

