/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.digest;

import io.takari.builder.internal.digest.BytesHash;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1Digester {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static MessageDigest newInstance() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported JVM", e);
        }
    }

    public static BytesHash digest(String string) {
        MessageDigest digest = SHA1Digester.newInstance();
        if (string != null) {
            digest.update(string.getBytes(UTF8));
        }
        return new BytesHash(digest.digest());
    }
}

