/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.model.override;

import com.google.common.collect.Sets;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.testng.annotations.Test;

public class SnakeCaseConverterTest {
    @Test(description="it should change naming style")
    public void testConvert() {
        SnakeCaseConverter snakeCaseConverter = new SnakeCaseConverter();
        ModelConverters converters = new ModelConverters();
        converters.addConverter((ModelConverter)snakeCaseConverter);
        Map models = converters.readAll(SnakeCaseModel.class);
        String json = "{   \"bar\":{      \"type\":\"object\",      \"properties\":{         \"foo\":{            \"type\":\"string\"         }      }   },   \"snake_case_model\":{      \"type\":\"object\",      \"properties\":{         \"bar\":{            \"$ref\":\"#/definitions/bar\"         },         \"title\":{            \"type\":\"string\"         }      },      \"xml\":{         \"name\":\"snakeCaseModel\"      }   }}";
        SerializationMatchers.assertEqualsToJson(models, "{   \"bar\":{      \"type\":\"object\",      \"properties\":{         \"foo\":{            \"type\":\"string\"         }      }   },   \"snake_case_model\":{      \"type\":\"object\",      \"properties\":{         \"bar\":{            \"$ref\":\"#/definitions/bar\"         },         \"title\":{            \"type\":\"string\"         }      },      \"xml\":{         \"name\":\"snakeCaseModel\"      }   }}");
    }

    class Bar {
        public String foo = null;

        Bar() {
        }
    }

    class SnakeCaseConverter
    implements ModelConverter {
        final Set<String> primitives = Sets.newHashSet((Object[])new String[]{"string", "integer", "number", "boolean", "long"});

        SnakeCaseConverter() {
        }

        public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
            if (chain.hasNext()) {
                ModelConverter converter = chain.next();
                return converter.resolveProperty(type, context, annotations, chain);
            }
            return null;
        }

        public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
            ModelConverter converter;
            Model model;
            if (chain.hasNext() && (model = (converter = chain.next()).resolve(type, context, chain)) != null) {
                Map properties = model.getProperties();
                LinkedHashMap<String, Property> updatedProperties = new LinkedHashMap<String, Property>();
                for (String key : properties.keySet()) {
                    String convertedKey = this.toSnakeCase(key);
                    Property prop = (Property)properties.get(key);
                    if (prop instanceof RefProperty) {
                        RefProperty ref = (RefProperty)prop;
                        ref.set$ref(this.toSnakeCase(ref.getSimpleRef()));
                    }
                    updatedProperties.put(convertedKey, prop);
                }
                model.getProperties().clear();
                model.setProperties(updatedProperties);
                if (model instanceof ModelImpl) {
                    ModelImpl impl = (ModelImpl)model;
                    String prevName = impl.getName();
                    impl.setName(this.toSnakeCase(impl.getName()));
                    context.defineModel(impl.getName(), (Model)impl, type, prevName);
                }
                return model;
            }
            return null;
        }

        private String toSnakeCase(String str) {
            String o = str.replaceAll("[A-Z\\d]", "_$0").toLowerCase();
            if (o.startsWith("_")) {
                return o.substring(1);
            }
            return o;
        }
    }

    @XmlRootElement(name="snakeCaseModel")
    class SnakeCaseModel {
        public Bar bar = null;
        public String title = null;

        SnakeCaseModel() {
        }
    }
}

