/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ImmutableTestWidget;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.Iterator;
import java.util.Map;
import org.immutables.value.Value;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImmutablesGenerationTest
extends SwaggerTestBase {
    private final ModelResolver modelResolver = new ModelResolver(new ObjectMapper());
    private final ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)this.modelResolver);

    @Test
    public void testImmutables() {
        Model model = this.context.resolve(TestWidget.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)2);
        Iterator it = props.values().iterator();
        Property prop = (Property)it.next();
        Assert.assertEquals((String)prop.getName(), (String)"wibble");
        prop = (Property)it.next();
        Assert.assertEquals((String)prop.getName(), (String)"wobble");
    }

    @JsonSerialize(as=ImmutableTestWidget.class)
    @Value.Immutable
    public static interface TestWidget {
        public String wibble();

        public String wobble();
    }
}

