/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class TestUtils {
    private static <T> T deserializeFileFromClasspath(String path, Class<T> type, ObjectMapper objectMapper) {
        String contents;
        InputStream resource = TestUtils.class.getClassLoader().getResourceAsStream(path);
        if (resource == null) {
            throw new RuntimeException("Could not find file on the classpath: " + path);
        }
        try {
            contents = IOUtils.toString((InputStream)resource);
        }
        catch (IOException e) {
            throw new RuntimeException("could not read from file " + path, e);
        }
        try {
            Object result = objectMapper.readValue(contents, type);
            return (T)result;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not deserialize contents into type: " + type, e);
        }
    }

    public static <T> T deserializeJsonFileFromClasspath(String path, Class<T> type) {
        return TestUtils.deserializeFileFromClasspath(path, type, Json.mapper());
    }

    public static <T> T deserializeYamlFileFromClasspath(String path, Class<T> type) {
        return TestUtils.deserializeFileFromClasspath(path, type, Yaml.mapper());
    }
}

