/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Contact;
import io.swagger.models.Error;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Person;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.OutputReplacer;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SwaggerSerializerTest {
    ObjectMapper m = Json.mapper();

    @Test(description="it should convert a spec")
    public void convertSpec() throws IOException {
        Model personModel = (Model)ModelConverters.getInstance().read(Person.class).get("Person");
        Model errorModel = (Model)ModelConverters.getInstance().read(Error.class).get("Error");
        Info info = new Info().version("1.0.0").title("Swagger Petstore");
        Contact contact = new Contact().name("Swagger API Team").email("foo@bar.baz").url("http://swagger.io");
        info.setContact(contact);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "value");
        info.setVendorExtension("x-test2", map);
        info.setVendorExtension("x-test", (Object)"value");
        Swagger swagger = new Swagger().info(info).host("petstore.swagger.io").securityDefinition("api-key", (SecuritySchemeDefinition)new ApiKeyAuthDefinition("key", In.HEADER)).scheme(Scheme.HTTP).consumes("application/json").produces("application/json").model("Person", personModel).model("Error", errorModel);
        Operation get = new Operation().produces("application/json").summary("finds pets in the system").description("a longer description").tag("Pet Operations").operationId("get pet by id").deprecated(Boolean.valueOf(true));
        get.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("tags")).description("tags to filter by")).required(false)).property((Property)new StringProperty()));
        get.parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("petId")).description("pet to fetch")).property((Property)new LongProperty()));
        Response response = new Response().description("pets returned").schema((Property)new RefProperty().asDefault("Person")).example("application/json", (Object)"fun!");
        Response errorResponse = new Response().description("error response").schema((Property)new RefProperty().asDefault("Error"));
        get.response(200, response).defaultResponse(errorResponse);
        Operation post = new Operation().summary("adds a new pet").description("you can add a new pet this way").tag("Pet Operations").operationId("add pet").defaultResponse(errorResponse).parameter((Parameter)new BodyParameter().description("the pet to add").schema((Model)new RefModel().asDefault("Person")));
        swagger.path("/pets", new Path().get(get).post(post));
        String swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Swagger rebuilt = (Swagger)Json.mapper().readValue(swaggerJson, Swagger.class);
        SerializationMatchers.assertEqualsToJson(rebuilt, swaggerJson);
    }

    @Test(description="it should read the uber api")
    public void readUberApi() throws IOException {
        String jsonString = ResourceUtils.loadClassResource(this.getClass(), "uber.json");
        Swagger swagger = (Swagger)Json.mapper().readValue(jsonString, Swagger.class);
        Assert.assertNotNull((Object)swagger);
    }

    @Test(description="it should write a spec with parameter references")
    public void writeSpecWithParameterReferences() throws IOException {
        Model personModel = (Model)ModelConverters.getInstance().read(Person.class).get("Person");
        Info info = new Info().version("1.0.0").title("Swagger Petstore");
        Contact contact = new Contact().name("Swagger API Team").email("foo@bar.baz").url("http://swagger.io");
        info.setContact(contact);
        Swagger swagger = new Swagger().info(info).host("petstore.swagger.io").securityDefinition("api-key", (SecuritySchemeDefinition)new ApiKeyAuthDefinition("key", In.HEADER)).scheme(Scheme.HTTP).consumes("application/json").produces("application/json").model("Person", personModel);
        QueryParameter parameter = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("id")).description("a common get parameter")).property((Property)new LongProperty());
        Operation get = new Operation().produces("application/json").summary("finds pets in the system").description("a longer description").tag("Pet Operations").operationId("get pet by id").parameter((Parameter)new RefParameter("foo"));
        swagger.parameter("foo", (Parameter)parameter).path("/pets", new Path().get(get));
        String swaggerJson = Json.mapper().writeValueAsString((Object)swagger);
        Swagger rebuilt = (Swagger)Json.mapper().readValue(swaggerJson, Swagger.class);
        Assert.assertEquals((String)Json.pretty((Object)swagger), (String)Json.pretty((Object)rebuilt));
    }

    @Test
    public void prettyPrintTest() throws IOException {
        String json = ResourceUtils.loadClassResource(this.getClass(), "uber.json");
        final Swagger swagger = (Swagger)Json.mapper().readValue(json, Swagger.class);
        String outputStream = OutputReplacer.OUT.run(new OutputReplacer.Function(){

            @Override
            public void run() {
                Json.prettyPrint((Object)swagger);
            }
        });
        SerializationMatchers.assertEqualsToJson(swagger, outputStream);
    }

    @Test
    public void exceptionsTest() throws IOException {
        String outputStream1 = OutputReplacer.ERROR.run(new OutputReplacer.Function(){

            @Override
            public void run() {
                Json.pretty((Object)new ThrowHelper());
            }
        });
        Assert.assertTrue((boolean)outputStream1.contains("Test exception"));
        String outputStream2 = OutputReplacer.ERROR.run(new OutputReplacer.Function(){

            @Override
            public void run() {
                Json.prettyPrint((Object)new ThrowHelper());
            }
        });
        Assert.assertTrue((boolean)outputStream2.contains("Test exception"));
    }

    static class ThrowHelper {
        public static final String MESSAGE = "Test exception";

        ThrowHelper() {
        }

        public String getValue() throws IOException {
            throw new IOException(MESSAGE);
        }

        public void setValue(String value) {
        }
    }
}

