/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObjectPropertyTest {
    @Test(description="convert a model with object properties")
    public void readModelWithObjectProperty() throws IOException {
        String json = "{   \"properties\":{      \"id\":{         \"type\":\"string\"      },      \"someObject\":{         \"type\":\"object\",        \"x-foo\": \"vendor x\",         \"properties\":{            \"innerId\":{               \"type\":\"string\"            }         }      }   }}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Property p = (Property)model.getProperties().get("someObject");
        Assert.assertTrue((boolean)(p instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)p;
        Property sp = (Property)op.getProperties().get("innerId");
        Assert.assertTrue((boolean)(sp instanceof StringProperty));
        Assert.assertTrue((op.getVendorExtensions() != null ? 1 : 0) != 0);
        Assert.assertNotNull(op.getVendorExtensions().get("x-foo"));
        Assert.assertEquals(op.getVendorExtensions().get("x-foo"), (Object)"vendor x");
    }
}

