/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.ModelContainingModelWithReference;
import io.swagger.models.ModelWithReference;
import java.io.IOException;
import java.util.Map;
import org.testng.annotations.Test;

public class ModelWithReferenceTest {
    @Test(description="it should convert a model with reference property")
    public void convertModelWithReferenceProperty() throws IOException {
        Map schemas = ModelConverters.getInstance().read(ModelWithReference.class);
        String json = "{\n   \"ModelWithReference\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"description\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models/Description\"\n         }\n      }\n   }\n}";
        SerializationMatchers.assertEqualsToJson(schemas, "{\n   \"ModelWithReference\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"description\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models/Description\"\n         }\n      }\n   }\n}");
    }

    @Test(description="it should convert a model with reference and reference property")
    public void convertModelWithReferenceAndReferenceProperty() throws IOException {
        Map schemas = ModelConverters.getInstance().read(ModelContainingModelWithReference.class);
        String json = "{\n   \"ModelContainingModelWithReference\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"model\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models\"\n         },\n         \"anotherModel\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models/AnotherModel\"\n         }\n      }\n   }\n}";
        SerializationMatchers.assertEqualsToJson(schemas, "{\n   \"ModelContainingModelWithReference\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"model\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models\"\n         },\n         \"anotherModel\":{\n            \"$ref\":\"http://swagger.io/schemas.json#/Models/AnotherModel\"\n         }\n      }\n   }\n}");
    }
}

