/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.ModelWithEnumField;
import io.swagger.models.ModelWithEnumField2707;
import io.swagger.models.ModelWithEnumProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnumPropertyTest {
    @Test(description="it should read a model with an enum property")
    public void testEnumProperty() {
        Map models = ModelConverters.getInstance().read(ModelWithEnumProperty.class);
        String json = "{   \"ModelWithEnumProperty\":{      \"type\":\"object\",      \"properties\":{         \"enumValue\":{            \"type\":\"string\",            \"enum\":[               \"PRIVATE\",               \"PUBLIC\",               \"SYSTEM\",               \"INVITE_ONLY\"            ]         }      }   }}";
        SerializationMatchers.assertEqualsToJson(models, "{   \"ModelWithEnumProperty\":{      \"type\":\"object\",      \"properties\":{         \"enumValue\":{            \"type\":\"string\",            \"enum\":[               \"PRIVATE\",               \"PUBLIC\",               \"SYSTEM\",               \"INVITE_ONLY\"            ]         }      }   }}");
    }

    @Test(description="it should extract enum values from fields")
    public void testExtractEnumFields() {
        Map models = ModelConverters.getInstance().read(ModelWithEnumField.class);
        Model model = (Model)models.get("ModelWithEnumField");
        Property enumProperty = (Property)model.getProperties().get("enumValue");
        Assert.assertTrue((boolean)(enumProperty instanceof StringProperty));
        StringProperty stringProperty = (StringProperty)enumProperty;
        Assert.assertEquals((Collection)stringProperty.getEnum(), Arrays.asList("PRIVATE", "PUBLIC", "SYSTEM", "INVITE_ONLY"));
    }

    @Test(description="it should extract enum values annotated with JsonProperty from fields")
    public void testExtractEnumFields2707() {
        Map models = ModelConverters.getInstance().read(ModelWithEnumField2707.class);
        Model model = (Model)models.get("ModelWithEnumField2707");
        Property enumProperty = (Property)model.getProperties().get("enumValue");
        Assert.assertTrue((boolean)(enumProperty instanceof StringProperty));
        StringProperty stringProperty = (StringProperty)enumProperty;
        Assert.assertEquals((Collection)stringProperty.getEnum(), Arrays.asList("private", "public"));
    }

    @Test(description="it should extract enum values from method return types")
    public void testExtractEnumReturnType() {
        Map models = ModelConverters.getInstance().read(ModelWithEnumProperty.class);
        Model model = (Model)models.get("ModelWithEnumProperty");
        Property enumProperty = (Property)model.getProperties().get("enumValue");
        Assert.assertTrue((boolean)(enumProperty instanceof StringProperty));
        StringProperty stringProperty = (StringProperty)enumProperty;
        Assert.assertEquals((Collection)stringProperty.getEnum(), Arrays.asList("PRIVATE", "PUBLIC", "SYSTEM", "INVITE_ONLY"));
    }
}

