/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.composition.AbstractBaseModelWithoutFields;
import io.swagger.models.composition.Animal;
import io.swagger.models.composition.Human;
import io.swagger.models.composition.ModelWithFieldWithSubTypes;
import io.swagger.util.ResourceUtils;
import java.io.IOException;
import java.util.Map;
import org.testng.annotations.Test;

public class CompositionTest {
    @Test(description="read a model with required params and description")
    public void readModelWithRequiredParams() throws IOException {
        this.compareAsJson(Human.class, "Human.json");
    }

    @Test(description="read a model with composition")
    public void readModelWithComposition() throws IOException {
        this.compareAsJson(Animal.class, "Animal.json");
    }

    @Test(description="create a model")
    public void createModel() throws IOException {
        this.compareAsJson(AbstractBaseModelWithoutFields.class, "AbstractBaseModelWithoutFields.json");
    }

    @Test(description="create a ModelWithFieldWithSubTypes")
    public void createModelWithFieldWithSubTypes() throws IOException {
        this.compareAsJson(ModelWithFieldWithSubTypes.class, "ModelWithFieldWithSubTypes.json");
    }

    @Test
    public void testTicket2189() throws IOException {
        Map schemas = ModelConverters.getInstance().readAll(BaseClass.class);
        SerializationMatchers.assertEqualsToYaml(schemas, "BaseClass:\n  type: \"object\"\n  properties:\n    property:\n      type: \"string\"\n    type:\n      type: \"string\"\nSubClass:\n  allOf:\n  - $ref: \"#/definitions/BaseClass\"\n  - type: \"object\"\n    properties:\n      subClassProperty:\n        type: \"string\"");
    }

    private void compareAsJson(Class<?> cls, String fileName) throws IOException {
        Map schemas = ModelConverters.getInstance().readAll(cls);
        String json = ResourceUtils.loadClassResource(this.getClass(), fileName);
        SerializationMatchers.assertEqualsToJson(schemas, json);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=SubClass.class, name="SubClass"), @JsonSubTypes.Type(value=BaseClass.class, name="BaseClass")})
    static class BaseClass {
        public String property;
        public String type;

        BaseClass() {
        }
    }

    static class SubClass
    extends BaseClass {
        public String subClassProperty;

        SubClass() {
        }
    }
}

