/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.ModelImpl;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ComposedProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComposedPropertyTest {
    @Test(description="convert a model with object properties")
    public void readModelWithObjectProperty() throws IOException {
        String json = "{\n  \"properties\":{\n    \"id\":{\n      \"type\":\"string\"\n    },\n    \"someObject\":{\n      \"type\":\"object\",\n      \"x-foo\": \"vendor x\",\n      \"allOf\":[\n        {\n          \"type\":\"object\",\n          \"properties\":{\n            \"innerId\":{\n              \"type\":\"string\"\n            }\n          }\n        },{\n          \"type\":\"object\",\n          \"properties\":{\n            \"innerLength\":{\n            \"type\":\"number\"\n            }\n          }\n        }\n      ]\n    }\n  }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Property p = (Property)model.getProperties().get("someObject");
        Assert.assertTrue((boolean)(p instanceof ComposedProperty));
        ComposedProperty cp = (ComposedProperty)p;
        Property op0 = (Property)cp.getAllOf().get(0);
        Property op1 = (Property)cp.getAllOf().get(1);
        Assert.assertTrue((boolean)(op0 instanceof ObjectProperty));
        Assert.assertTrue((boolean)(op1 instanceof ObjectProperty));
        Property sp = (Property)((ObjectProperty)op0).getProperties().get("innerId");
        Property np = (Property)((ObjectProperty)op1).getProperties().get("innerLength");
        Assert.assertTrue((boolean)(sp instanceof StringProperty));
        Assert.assertTrue((boolean)(np instanceof AbstractNumericProperty));
        Assert.assertTrue((cp.getVendorExtensions() != null ? 1 : 0) != 0);
        Assert.assertNotNull(cp.getVendorExtensions().get("x-foo"));
        Assert.assertEquals(cp.getVendorExtensions().get("x-foo"), (Object)"vendor x");
    }
}

