/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.urlresolver.PermittedUrlsChecker;
import io.swagger.v3.parser.util.ManagedValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUrl {
    static final Logger LOGGER = LoggerFactory.getLogger(RemoteUrl.class);
    private static final String TRUST_ALL = String.format("%s.trustAll", RemoteUrl.class.getName());
    private static final ConnectionConfigurator CONNECTION_CONFIGURATOR = RemoteUrl.createConnectionConfigurator();
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String ACCEPT_HEADER_VALUE = "application/json, application/yaml, */*";
    private static final String USER_AGENT_HEADER_VALUE = "Apache-HttpClient/Swagger";
    static final int CONNECTION_TIMEOUT = 30000;
    static final int READ_TIMEOUT = 60000;
    private static final int MAX_REDIRECTS = 5;

    static ConnectionConfigurator createConnectionConfigurator() {
        if (Boolean.parseBoolean(System.getProperty(TRUST_ALL))) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sf = sc.getSocketFactory();
                HostnameVerifier trustAllNames = (hostname, session) -> true;
                return connection -> {
                    if (connection instanceof HttpsURLConnection) {
                        HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                        httpsConnection.setSSLSocketFactory(sf);
                        httpsConnection.setHostnameVerifier(trustAllNames);
                        httpsConnection.setConnectTimeout(30000);
                        httpsConnection.setReadTimeout(60000);
                        httpsConnection.setInstanceFollowRedirects(false);
                    }
                };
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LOGGER.error("Not Supported", (Throwable)e);
            }
        }
        return connection -> {
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
        };
    }

    public static String cleanUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replace("{", "%7B").replace("}", "%7D").replace(" ", "%20");
    }

    public static String urlToString(String url, List<AuthorizationValue> auths) throws Exception {
        return RemoteUrl.urlToString(url, auths, null);
    }

    public static String urlToString(String url, List<AuthorizationValue> auths, PermittedUrlsChecker permittedUrlsChecker) throws Exception {
        try {
            for (int redirectCount = 0; redirectCount <= 5; ++redirectCount) {
                if (redirectCount > 0 && permittedUrlsChecker != null) {
                    permittedUrlsChecker.verify(url);
                }
                URL inUrl = new URL(RemoteUrl.cleanUrl(url));
                ArrayList<AuthorizationValue> query = new ArrayList<AuthorizationValue>();
                ArrayList<AuthorizationValue> header = new ArrayList<AuthorizationValue>();
                RemoteUrl.filterAndAssignAuthValues(auths, inUrl, query, header);
                URLConnection conn = RemoteUrl.prepareConnection(query, inUrl);
                CONNECTION_CONFIGURATOR.process(conn);
                RemoteUrl.setRequestHeaders(header, conn);
                conn.connect();
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                if (RemoteUrl.isRedirect(httpConn)) {
                    url = conn.getHeaderField("Location");
                    if (url != null) continue;
                    throw new IOException("Redirect response missing 'Location' header");
                }
                return RemoteUrl.readResponse(conn);
            }
            throw new IOException("Too many redirects (> 5)");
        }
        catch (SSLProtocolException e) {
            LOGGER.warn("there is a problem with the target SSL certificate");
            LOGGER.warn("**** you may want to run with -Djsse.enableSNIExtension=false\n\n");
            LOGGER.error("unable to read {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("unable to read {}", (Object)e.getMessage());
            throw e;
        }
    }

    private static void filterAndAssignAuthValues(List<AuthorizationValue> auths, URL inUrl, List<AuthorizationValue> query, List<AuthorizationValue> header) {
        if (auths != null && !auths.isEmpty()) {
            for (AuthorizationValue auth : auths) {
                if (auth.getUrlMatcher() == null || !auth.getUrlMatcher().test(inUrl)) continue;
                if ("query".equals(auth.getType())) {
                    RemoteUrl.appendValue(inUrl, auth, query);
                    continue;
                }
                if (!"header".equals(auth.getType())) continue;
                RemoteUrl.appendValue(inUrl, auth, header);
            }
        }
    }

    private static String readResponse(URLConnection conn) throws IOException {
        try (InputStream in = conn.getInputStream();){
            String string;
            try (BufferedReader input = new BufferedReader(new InputStreamReader(in, UTF_8));){
                int ch;
                StringBuilder contents = new StringBuilder();
                while ((ch = input.read()) != -1) {
                    char c = (char)ch;
                    if (Character.isISOControl(c) && c != '\n') continue;
                    contents.append(c);
                }
                string = contents.toString();
            }
            return string;
        }
    }

    private static void setRequestHeaders(List<AuthorizationValue> header, URLConnection conn) {
        for (AuthorizationValue item : header) {
            conn.setRequestProperty(item.getKeyName(), item.getValue());
        }
        conn.setRequestProperty("Accept", ACCEPT_HEADER_VALUE);
        conn.setRequestProperty("User-Agent", USER_AGENT_HEADER_VALUE);
    }

    private static URLConnection prepareConnection(List<AuthorizationValue> query, URL inUrl) throws URISyntaxException, IOException {
        URLConnection conn;
        if (!query.isEmpty()) {
            URI inUri = inUrl.toURI();
            StringBuilder newQuery = new StringBuilder(inUri.getQuery() == null ? "" : inUri.getQuery());
            for (AuthorizationValue item : query) {
                if (newQuery.length() > 0) {
                    newQuery.append("&");
                }
                newQuery.append(URLEncoder.encode(item.getKeyName(), UTF_8.name())).append("=").append(URLEncoder.encode(item.getValue(), UTF_8.name()));
            }
            conn = new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), newQuery.toString(), inUri.getFragment()).toURL().openConnection();
        } else {
            conn = inUrl.openConnection();
        }
        return conn;
    }

    private static boolean isRedirect(HttpURLConnection conn) throws IOException {
        int code = conn.getResponseCode();
        return code == 301 || code == 302 || code == 303 || code == 307 || code == 308;
    }

    private static void appendValue(URL url, AuthorizationValue value, Collection<AuthorizationValue> to) {
        if (value instanceof ManagedValue && !((ManagedValue)value).process(url)) {
            return;
        }
        to.add(value);
    }

    static interface ConnectionConfigurator {
        public void process(URLConnection var1);
    }
}

