/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.util.RefUtils;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private boolean aggregateCombinators;
    private Map<String, Schema> schemas;
    private Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;
    private Map<String, RequestBody> requestBodies;

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public void resolveFully(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getRequestBodies() != null) {
            this.requestBodies = openAPI.getComponents().getRequestBodies();
            if (this.requestBodies == null) {
                this.requestBodies = new HashMap<String, RequestBody>();
            }
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            this.schemas = openAPI.getComponents().getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getExamples() != null) {
            this.examples = openAPI.getComponents().getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            RequestBody refRequestBody;
            Content content;
            if (op.getParameters() != null) {
                for (Parameter parameter : op.getParameters()) {
                    Schema resolved;
                    if (parameter.getSchema() != null && (resolved = this.resolveSchema(parameter.getSchema())) != null) {
                        parameter.setSchema(resolved);
                    }
                    if (parameter.getContent() == null) continue;
                    content = parameter.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Parameter parameter;
                Map callbacks = op.getCallbacks();
                parameter = callbacks.keySet().iterator();
                while (parameter.hasNext()) {
                    Object key;
                    String name = (String)parameter.next();
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    key = callback.keySet().iterator();
                    while (key.hasNext()) {
                        String callbackName = (String)key.next();
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if ((refRequestBody = op.getRequestBody()) != null) {
                RequestBody requestBody;
                RequestBody requestBody2 = requestBody = refRequestBody.get$ref() != null ? this.resolveRequestBody(refRequestBody) : refRequestBody;
                if (requestBody.getContent() != null) {
                    content = requestBody.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolved;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolved);
                    }
                }
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)op.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content2 = response.getContent();
                for (String mediaType : content2.keySet()) {
                    Object resolved;
                    if (((MediaType)content2.get(mediaType)).getSchema() != null) {
                        resolved = this.resolveSchema(((MediaType)content2.get(mediaType)).getSchema());
                        ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                    }
                    if (((MediaType)content2.get(mediaType)).getExamples() == null) continue;
                    resolved = this.resolveExample(((MediaType)content2.get(mediaType)).getExamples());
                    ((MediaType)response.getContent().get((Object)mediaType)).setExamples((Map)resolved);
                }
            }
        }
    }

    public RequestBody resolveRequestBody(RequestBody requestBody) {
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody.get$ref());
        String $ref = requestBody.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.requestBodies != null && !this.requestBodies.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.requestBodies.getOrDefault(referenceKey, requestBody);
        }
        return requestBody;
    }

    public Schema resolveSchema(Schema schema) {
        if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            Schema resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Schema model = this.resolveSchema(resolved);
            this.resolvedModels.put(ref, model);
            return model;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            if (arrayModel.getItems().get$ref() != null) {
                arrayModel.setItems(this.resolveSchema(arrayModel.getItems()));
            } else {
                arrayModel.setItems(arrayModel.getItems());
            }
            return arrayModel;
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema obj = (ObjectSchema)schema;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Schema innerProperty = (Schema)obj.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    Schema resolved = this.resolveSchema(innerProperty);
                    updated.put(propertyName, resolved);
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            boolean adjacent = false;
            if (this.aggregateCombinators) {
                Schema resolved;
                ArrayList<Schema> list;
                String key3;
                Schema prop;
                Iterator key22;
                Map properties;
                Object resolved2;
                Schema model = SchemaTypeUtil.createSchema(composedSchema.getType(), composedSchema.getFormat());
                HashSet<String> requiredProperties = new HashSet<String>();
                HashSet<Object> examples = new HashSet<Object>();
                if (composedSchema.getAllOf() != null && composedSchema.getAnyOf() != null && composedSchema.getOneOf() != null || composedSchema.getAllOf() != null && composedSchema.getAnyOf() != null || composedSchema.getAllOf() != null && composedSchema.getOneOf() != null || composedSchema.getOneOf() != null && composedSchema.getAnyOf() != null) {
                    adjacent = true;
                }
                if (composedSchema.getAllOf() != null) {
                    for (Schema innerModel : composedSchema.getAllOf()) {
                        resolved2 = this.resolveSchema(innerModel);
                        properties = resolved2.getProperties();
                        if (resolved2.getProperties() != null) {
                            for (Iterator key22 : properties.keySet()) {
                                prop = (Schema)resolved2.getProperties().get(key22);
                                model.addProperties(key22, this.resolveSchema(prop));
                            }
                            if (resolved2.getRequired() != null) {
                                for (int i = 0; i < resolved2.getRequired().size(); ++i) {
                                    if (resolved2.getRequired().get(i) == null) continue;
                                    requiredProperties.add(resolved2.getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList(requiredProperties));
                        }
                        if (resolved2.getExample() != null) {
                            examples.add(resolved2.getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map extensions = composedSchema.getExtensions();
                        key22 = extensions.keySet().iterator();
                        while (key22.hasNext()) {
                            key3 = (String)key22.next();
                            model.addExtension(key3, composedSchema.getExtensions().get(key3));
                        }
                    }
                }
                if (composedSchema.getOneOf() != null) {
                    if (!adjacent) {
                        list = new ArrayList<Schema>();
                        for (Schema innerModel : composedSchema.getOneOf()) {
                            resolved = this.resolveSchema(innerModel);
                            list.add(resolved);
                        }
                        composedSchema.setOneOf(list);
                        return composedSchema;
                    }
                    for (Schema innerModel : composedSchema.getOneOf()) {
                        resolved2 = this.resolveSchema(innerModel);
                        properties = resolved2.getProperties();
                        if (resolved2.getProperties() != null) {
                            for (Iterator key22 : properties.keySet()) {
                                prop = (Schema)resolved2.getProperties().get(key22);
                                model.addProperties(key22, this.resolveSchema(prop));
                            }
                            if (resolved2.getRequired() != null) {
                                for (int i = 0; i < resolved2.getRequired().size(); ++i) {
                                    if (resolved2.getRequired().get(i) == null) continue;
                                    requiredProperties.add(resolved2.getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList(requiredProperties));
                        }
                        if (resolved2.getExample() != null) {
                            examples.add(resolved2.getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map extensions = composedSchema.getExtensions();
                        key22 = extensions.keySet().iterator();
                        while (key22.hasNext()) {
                            key3 = (String)key22.next();
                            model.addExtension(key3, composedSchema.getExtensions().get(key3));
                        }
                    }
                }
                if (composedSchema.getAnyOf() != null) {
                    if (!adjacent) {
                        list = new ArrayList();
                        for (Schema innerModel : composedSchema.getAnyOf()) {
                            resolved = this.resolveSchema(innerModel);
                            list.add(resolved);
                        }
                        composedSchema.setAnyOf(list);
                        return composedSchema;
                    }
                    for (Schema innerModel : composedSchema.getAnyOf()) {
                        resolved2 = this.resolveSchema(innerModel);
                        properties = resolved2.getProperties();
                        if (resolved2.getProperties() != null) {
                            for (Iterator key22 : properties.keySet()) {
                                prop = (Schema)resolved2.getProperties().get(key22);
                                model.addProperties(key22, this.resolveSchema(prop));
                            }
                            if (resolved2.getRequired() != null) {
                                for (int i = 0; i < resolved2.getRequired().size(); ++i) {
                                    if (resolved2.getRequired().get(i) == null) continue;
                                    requiredProperties.add(resolved2.getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList(requiredProperties));
                        }
                        if (resolved2.getExample() != null) {
                            examples.add(resolved2.getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map extensions = composedSchema.getExtensions();
                        for (String key3 : extensions.keySet()) {
                            model.addExtension(key3, composedSchema.getExtensions().get(key3));
                        }
                    }
                }
                model.setExample(examples);
                return model;
            }
            if (composedSchema.getAllOf() != null) {
                composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            if (composedSchema.getOneOf() != null) {
                composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            if (composedSchema.getAnyOf() != null) {
                composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            return composedSchema;
        }
        if (schema.getProperties() != null) {
            Schema property;
            Schema model = schema;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = (Schema)model.getProperties().get(propertyName);
                Schema resolved = this.resolveSchema(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (!(property instanceof ObjectSchema)) continue;
                ObjectSchema op = (ObjectSchema)property;
                if (op.getProperties() != model.getProperties()) {
                    if (property.getType() == null) {
                        property.setType("object");
                    }
                    model.addProperties(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                ObjectSchema newSchema = new ObjectSchema();
                model.addProperties(key, (Schema)newSchema);
            }
            return model;
        }
        return schema;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).get$ref() == null) continue;
                String ref = examples.get(name).get$ref();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample = this.examples.get(ref);
                resolveExamples.replace(name, sample);
            }
        }
        return resolveExamples;
    }
}

