/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.BaseFluent;
import io.sundr.builder.Nested;
import io.sundr.model.Source;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeDefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SourceFluent<A extends SourceFluent<A>>
extends BaseFluent<A> {
    private ArrayList<TypeDefBuilder> types = new ArrayList();

    public SourceFluent() {
    }

    public SourceFluent(Source instance) {
        this.copyInstance(instance);
    }

    public A addAllToTypes(Collection<TypeDef> items) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"types").add(builder);
            this.types.add(builder);
        }
        return (A)((Object)this);
    }

    public TypesNested<A> addNewType() {
        return new TypesNested(-1, null);
    }

    public A addNewType(String fullyQualifiedName) {
        return this.addToTypes(new TypeDef(fullyQualifiedName));
    }

    public TypesNested<A> addNewTypeLike(TypeDef item) {
        return new TypesNested(-1, item);
    }

    public A addToTypes(TypeDef ... items) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"types").add(builder);
            this.types.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTypes(int index, TypeDef item) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        TypeDefBuilder builder = new TypeDefBuilder(item);
        if (index < 0 || index >= this.types.size()) {
            this._visitables.get((Object)"types").add(builder);
            this.types.add(builder);
        } else {
            this._visitables.get((Object)"types").add(builder);
            this.types.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TypeDef buildFirstType() {
        return this.types.get(0).build();
    }

    public TypeDef buildLastType() {
        return this.types.get(this.types.size() - 1).build();
    }

    public TypeDef buildMatchingType(Predicate<TypeDefBuilder> predicate) {
        for (TypeDefBuilder item : this.types) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TypeDef buildType(int index) {
        return this.types.get(index).build();
    }

    public List<TypeDef> buildTypes() {
        return this.types != null ? SourceFluent.build(this.types) : null;
    }

    protected void copyInstance(Source instance) {
        Source source = instance = instance != null ? instance : new Source();
        if (instance != null) {
            this.withTypes(instance.getTypes());
        }
    }

    public TypesNested<A> editFirstType() {
        if (this.types.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "types"));
        }
        return this.setNewTypeLike(0, this.buildType(0));
    }

    public TypesNested<A> editLastType() {
        int index = this.types.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "types"));
        }
        return this.setNewTypeLike(index, this.buildType(index));
    }

    public TypesNested<A> editMatchingType(Predicate<TypeDefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.types.size(); ++i) {
            if (!predicate.test(this.types.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "types"));
        }
        return this.setNewTypeLike(index, this.buildType(index));
    }

    public TypesNested<A> editType(int index) {
        if (this.types.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "types"));
        }
        return this.setNewTypeLike(index, this.buildType(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceFluent that = (SourceFluent)((Object)o);
        return Objects.equals(this.types, that.types);
    }

    public boolean hasMatchingType(Predicate<TypeDefBuilder> predicate) {
        for (TypeDefBuilder item : this.types) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTypes() {
        return this.types != null && !this.types.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.types);
    }

    public A removeAllFromTypes(Collection<TypeDef> items) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"types").remove((Object)builder);
            this.types.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(TypeDef ... items) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        for (TypeDef item : items) {
            TypeDefBuilder builder = new TypeDefBuilder(item);
            this._visitables.get((Object)"types").remove((Object)builder);
            this.types.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTypes(Predicate<TypeDefBuilder> predicate) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        Iterator<TypeDefBuilder> each = this.types.iterator();
        List visitables = this._visitables.get((Object)"types");
        while (each.hasNext()) {
            TypeDefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TypesNested<A> setNewTypeLike(int index, TypeDef item) {
        return new TypesNested(index, item);
    }

    public A setToTypes(int index, TypeDef item) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        TypeDefBuilder builder = new TypeDefBuilder(item);
        if (index < 0 || index >= this.types.size()) {
            this._visitables.get((Object)"types").add(builder);
            this.types.add(builder);
        } else {
            this._visitables.get((Object)"types").add(builder);
            this.types.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.types != null && !this.types.isEmpty()) {
            sb.append("types:");
            sb.append(this.types);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withTypes(List<TypeDef> types) {
        if (this.types != null) {
            this._visitables.get((Object)"types").clear();
        }
        if (types != null) {
            this.types = new ArrayList();
            for (TypeDef item : types) {
                this.addToTypes(item);
            }
        } else {
            this.types = null;
        }
        return (A)((Object)this);
    }

    public A withTypes(TypeDef ... types) {
        if (this.types != null) {
            this.types.clear();
            this._visitables.remove((Object)"types");
        }
        if (types != null) {
            for (TypeDef item : types) {
                this.addToTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public class TypesNested<N>
    extends TypeDefFluent<TypesNested<N>>
    implements Nested<N> {
        TypeDefBuilder builder;
        int index;

        TypesNested(int index, TypeDef item) {
            this.index = index;
            this.builder = new TypeDefBuilder(this, item);
        }

        public N and() {
            return (N)SourceFluent.this.setToTypes(this.index, this.builder.build());
        }

        public N endType() {
            return this.and();
        }
    }
}

