/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluent;
import io.sundr.model.TypeRef;
import io.sundr.model.TypeRefFluent;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluent;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClassRefFluent<A extends ClassRefFluent<A>>
extends TypeRefFluent<A> {
    private ArrayList<VisitableBuilder<? extends TypeRef, ?>> arguments = new ArrayList();
    private int dimensions;
    private String fullyQualifiedName;

    public ClassRefFluent() {
    }

    public ClassRefFluent(ClassRef instance) {
        this.copyInstance(instance);
    }

    public A addAllToArguments(Collection<TypeRef> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = ClassRefFluent.builder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)((Object)this);
    }

    public ClassRefArgumentsNested<A> addNewClassRefArgument() {
        return new ClassRefArgumentsNested(-1, null);
    }

    public ClassRefArgumentsNested<A> addNewClassRefArgumentLike(ClassRef item) {
        return new ClassRefArgumentsNested(-1, item);
    }

    public PrimitiveRefArgumentsNested<A> addNewPrimitiveRefArgument() {
        return new PrimitiveRefArgumentsNested(-1, null);
    }

    public PrimitiveRefArgumentsNested<A> addNewPrimitiveRefArgumentLike(PrimitiveRef item) {
        return new PrimitiveRefArgumentsNested(-1, item);
    }

    public TypeParamRefArgumentsNested<A> addNewTypeParamRefArgument() {
        return new TypeParamRefArgumentsNested(-1, null);
    }

    public TypeParamRefArgumentsNested<A> addNewTypeParamRefArgumentLike(TypeParamRef item) {
        return new TypeParamRefArgumentsNested(-1, item);
    }

    public VoidRefArgumentsNested<A> addNewVoidRefArgument() {
        return new VoidRefArgumentsNested(-1, null);
    }

    public VoidRefArgumentsNested<A> addNewVoidRefArgumentLike(VoidRef item) {
        return new VoidRefArgumentsNested(-1, item);
    }

    public WildcardRefArgumentsNested<A> addNewWildcardRefArgument() {
        return new WildcardRefArgumentsNested(-1, null);
    }

    public WildcardRefArgumentsNested<A> addNewWildcardRefArgumentLike(WildcardRef item) {
        return new WildcardRefArgumentsNested(-1, item);
    }

    public A addToArguments(VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this._visitables.get((Object)"arguments").add(builder);
        this.arguments.add(builder);
        return (A)((Object)this);
    }

    public A addToArguments(TypeRef ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = ClassRefFluent.builder(item);
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToArguments(int index, VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        if (index < 0 || index >= this.arguments.size()) {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        } else {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArguments(int index, TypeRef item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        VisitableBuilder builder = ClassRefFluent.builder(item);
        if (index < 0 || index >= this.arguments.size()) {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        } else {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TypeRef buildArgument(int index) {
        return (TypeRef)this.arguments.get(index).build();
    }

    public List<TypeRef> buildArguments() {
        return ClassRefFluent.build(this.arguments);
    }

    public TypeRef buildFirstArgument() {
        return (TypeRef)this.arguments.get(0).build();
    }

    public TypeRef buildLastArgument() {
        return (TypeRef)this.arguments.get(this.arguments.size() - 1).build();
    }

    public TypeRef buildMatchingArgument(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        for (VisitableBuilder<? extends TypeRef, ?> visitableBuilder : this.arguments) {
            if (!predicate.test(visitableBuilder)) continue;
            return (TypeRef)visitableBuilder.build();
        }
        return null;
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "ClassRef": {
                return new ClassRefBuilder((ClassRef)item);
            }
            case "PrimitiveRef": {
                return new PrimitiveRefBuilder((PrimitiveRef)item);
            }
            case "VoidRef": {
                return new VoidRefBuilder((VoidRef)item);
            }
            case "TypeParamRef": {
                return new TypeParamRefBuilder((TypeParamRef)item);
            }
            case "WildcardRef": {
                return new WildcardRefBuilder((WildcardRef)item);
            }
        }
        return ClassRefFluent.builderOf((Object)item);
    }

    protected void copyInstance(ClassRef instance) {
        if (instance != null) {
            this.withFullyQualifiedName(instance.getFullyQualifiedName());
            this.withDimensions(instance.getDimensions());
            this.withArguments(instance.getArguments());
            this.withAttributes(instance.getAttributes());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassRefFluent that = (ClassRefFluent)((Object)o);
        if (!Objects.equals(this.fullyQualifiedName, that.fullyQualifiedName)) {
            return false;
        }
        if (this.dimensions != that.dimensions) {
            return false;
        }
        return Objects.equals(this.arguments, that.arguments);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public boolean hasDimensions() {
        return true;
    }

    public boolean hasFullyQualifiedName() {
        return this.fullyQualifiedName != null;
    }

    public boolean hasMatchingArgument(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        for (VisitableBuilder<? extends TypeRef, ?> visitableBuilder : this.arguments) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fullyQualifiedName, this.dimensions, this.arguments);
    }

    public A removeAllFromArguments(Collection<TypeRef> items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = ClassRefFluent.builder(item);
            this._visitables.get((Object)"arguments").remove(builder);
            this.arguments.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromArguments(VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        this._visitables.get((Object)"arguments").remove(builder);
        this.arguments.remove(builder);
        return (A)((Object)this);
    }

    public A removeFromArguments(TypeRef ... items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = ClassRefFluent.builder(item);
            this._visitables.get((Object)"arguments").remove(builder);
            this.arguments.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromArguments(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        Iterator<VisitableBuilder<TypeRef, ?>> each = this.arguments.iterator();
        List visitables = this._visitables.get((Object)"arguments");
        while (each.hasNext()) {
            VisitableBuilder<? extends TypeRef, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ClassRefArgumentsNested<A> setNewClassRefArgumentLike(int index, ClassRef item) {
        return new ClassRefArgumentsNested(index, item);
    }

    public PrimitiveRefArgumentsNested<A> setNewPrimitiveRefArgumentLike(int index, PrimitiveRef item) {
        return new PrimitiveRefArgumentsNested(index, item);
    }

    public TypeParamRefArgumentsNested<A> setNewTypeParamRefArgumentLike(int index, TypeParamRef item) {
        return new TypeParamRefArgumentsNested(index, item);
    }

    public VoidRefArgumentsNested<A> setNewVoidRefArgumentLike(int index, VoidRef item) {
        return new VoidRefArgumentsNested(index, item);
    }

    public WildcardRefArgumentsNested<A> setNewWildcardRefArgumentLike(int index, WildcardRef item) {
        return new WildcardRefArgumentsNested(index, item);
    }

    public A setToArguments(int index, TypeRef item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        VisitableBuilder builder = ClassRefFluent.builder(item);
        if (index < 0 || index >= this.arguments.size()) {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.add(builder);
        } else {
            this._visitables.get((Object)"arguments").add(builder);
            this.arguments.set(index, builder);
        }
        return (A)((Object)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fullyQualifiedName != null) {
            sb.append("fullyQualifiedName:");
            sb.append(this.fullyQualifiedName);
            sb.append(",");
        }
        sb.append("dimensions:");
        sb.append(this.dimensions);
        sb.append(",");
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withArguments(List<TypeRef> arguments) {
        if (arguments != null) {
            this.arguments = new ArrayList();
            for (TypeRef item : arguments) {
                this.addToArguments(item);
            }
        } else {
            this.arguments = null;
        }
        return (A)((Object)this);
    }

    public A withArguments(TypeRef ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
            this._visitables.remove((Object)"arguments");
        }
        if (arguments != null) {
            for (TypeRef item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDimensions(int dimensions) {
        this.dimensions = dimensions;
        return (A)((Object)this);
    }

    public A withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return (A)((Object)this);
    }

    public class ClassRefArgumentsNested<N>
    extends ClassRefFluent<ClassRefArgumentsNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        ClassRefArgumentsNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)ClassRefFluent.this.setToArguments(this.index, (TypeRef)this.builder.build());
        }

        public N endClassRefArgument() {
            return this.and();
        }
    }

    public class PrimitiveRefArgumentsNested<N>
    extends PrimitiveRefFluent<PrimitiveRefArgumentsNested<N>>
    implements Nested<N> {
        PrimitiveRefBuilder builder;
        int index;

        PrimitiveRefArgumentsNested(int index, PrimitiveRef item) {
            this.index = index;
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        public N and() {
            return (N)ClassRefFluent.this.setToArguments(this.index, (TypeRef)this.builder.build());
        }

        public N endPrimitiveRefArgument() {
            return this.and();
        }
    }

    public class TypeParamRefArgumentsNested<N>
    extends TypeParamRefFluent<TypeParamRefArgumentsNested<N>>
    implements Nested<N> {
        TypeParamRefBuilder builder;
        int index;

        TypeParamRefArgumentsNested(int index, TypeParamRef item) {
            this.index = index;
            this.builder = new TypeParamRefBuilder(this, item);
        }

        public N and() {
            return (N)ClassRefFluent.this.setToArguments(this.index, (TypeRef)this.builder.build());
        }

        public N endTypeParamRefArgument() {
            return this.and();
        }
    }

    public class VoidRefArgumentsNested<N>
    extends VoidRefFluent<VoidRefArgumentsNested<N>>
    implements Nested<N> {
        VoidRefBuilder builder;
        int index;

        VoidRefArgumentsNested(int index, VoidRef item) {
            this.index = index;
            this.builder = new VoidRefBuilder(this, item);
        }

        public N and() {
            return (N)ClassRefFluent.this.setToArguments(this.index, (TypeRef)this.builder.build());
        }

        public N endVoidRefArgument() {
            return this.and();
        }
    }

    public class WildcardRefArgumentsNested<N>
    extends WildcardRefFluent<WildcardRefArgumentsNested<N>>
    implements Nested<N> {
        WildcardRefBuilder builder;
        int index;

        WildcardRefArgumentsNested(int index, WildcardRef item) {
            this.index = index;
            this.builder = new WildcardRefBuilder(this, item);
        }

        public N and() {
            return (N)ClassRefFluent.this.setToArguments(this.index, (TypeRef)this.builder.build());
        }

        public N endWildcardRefArgument() {
            return this.and();
        }
    }
}

