/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AnnotationRefFluent;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.Expression;
import io.sundr.model.ModifierSupportFluent;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluent;
import io.sundr.model.Property;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluent;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluent;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import io.sundr.model.WildcardRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PropertyFluent<A extends PropertyFluent<A>>
extends ModifierSupportFluent<A> {
    private List<String> comments = new ArrayList<String>();
    private ArrayList<AnnotationRefBuilder> annotations = new ArrayList();
    private VisitableBuilder<? extends TypeRef, ?> typeRef;
    private String name;
    private Optional<Expression> initialValue = Optional.empty();
    private boolean enumConstant;
    private boolean synthetic;

    public PropertyFluent() {
    }

    public PropertyFluent(Property instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Property instance) {
        if (instance != null) {
            this.withModifiers(instance.getModifiers());
            this.withAttributes(instance.getAttributes());
            this.withComments(instance.getComments());
            this.withAnnotations(instance.getAnnotations());
            this.withTypeRef(instance.getTypeRef());
            this.withName(instance.getName());
            this.withInitialValue(instance.getInitialValue());
            this.withEnumConstant(instance.isEnumConstant());
            this.withSynthetic(instance.isSynthetic());
        }
    }

    public A addToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(index, item);
        return (A)((Object)this);
    }

    public A setToComments(int index, String item) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.set(index, item);
        return (A)((Object)this);
    }

    public A addToComments(String ... items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToComments(Collection<String> items) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        for (String item : items) {
            this.comments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromComments(String ... items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromComments(Collection<String> items) {
        if (this.comments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.comments.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getComment(int index) {
        return this.comments.get(index);
    }

    public String getFirstComment() {
        return this.comments.get(0);
    }

    public String getLastComment() {
        return this.comments.get(this.comments.size() - 1);
    }

    public String getMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingComment(Predicate<String> predicate) {
        for (String item : this.comments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withComments(List<String> comments) {
        if (comments != null) {
            this.comments = new ArrayList<String>();
            for (String item : comments) {
                this.addToComments(item);
            }
        } else {
            this.comments = null;
        }
        return (A)((Object)this);
    }

    public A withComments(String ... comments) {
        if (this.comments != null) {
            this.comments.clear();
            this._visitables.remove((Object)"comments");
        }
        if (comments != null) {
            for (String item : comments) {
                this.addToComments(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public A addToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAnnotations(int index, AnnotationRef item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(AnnotationRef ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAnnotations(Collection<AnnotationRef> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (AnnotationRef item : items) {
            AnnotationRefBuilder builder = new AnnotationRefBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationRefBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationRefBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AnnotationRef> buildAnnotations() {
        return this.annotations != null ? PropertyFluent.build(this.annotations) : null;
    }

    public AnnotationRef buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public AnnotationRef buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public AnnotationRef buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public AnnotationRef buildMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        for (AnnotationRefBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAnnotations(List<AnnotationRef> annotations) {
        if (this.annotations != null) {
            this._visitables.get((Object)"annotations").clear();
        }
        if (annotations != null) {
            this.annotations = new ArrayList();
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        } else {
            this.annotations = null;
        }
        return (A)((Object)this);
    }

    public A withAnnotations(AnnotationRef ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (AnnotationRef item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(AnnotationRef item) {
        return new AnnotationsNested(-1, item);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, AnnotationRef item) {
        return new AnnotationsNested(index, item);
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public TypeRef buildTypeRef() {
        return this.typeRef != null ? (TypeRef)this.typeRef.build() : null;
    }

    public A withTypeRef(TypeRef typeRef) {
        if (typeRef == null) {
            this.typeRef = null;
            this._visitables.remove((Object)"typeRef");
            return (A)((Object)this);
        }
        VisitableBuilder builder = PropertyFluent.builder(typeRef);
        this._visitables.get((Object)"typeRef").clear();
        this._visitables.get((Object)"typeRef").add(builder);
        this.typeRef = builder;
        return (A)((Object)this);
    }

    public boolean hasTypeRef() {
        return this.typeRef != null;
    }

    public ClassRefTypeNested<A> withNewClassRefType() {
        return new ClassRefTypeNested(null);
    }

    public ClassRefTypeNested<A> withNewClassRefTypeLike(ClassRef item) {
        return new ClassRefTypeNested(item);
    }

    public PrimitiveRefTypeNested<A> withNewPrimitiveRefType() {
        return new PrimitiveRefTypeNested(null);
    }

    public PrimitiveRefTypeNested<A> withNewPrimitiveRefTypeLike(PrimitiveRef item) {
        return new PrimitiveRefTypeNested(item);
    }

    public VoidRefTypeNested<A> withNewVoidRefType() {
        return new VoidRefTypeNested(null);
    }

    public VoidRefTypeNested<A> withNewVoidRefTypeLike(VoidRef item) {
        return new VoidRefTypeNested(item);
    }

    public TypeParamRefTypeNested<A> withNewTypeParamRefType() {
        return new TypeParamRefTypeNested(null);
    }

    public TypeParamRefTypeNested<A> withNewTypeParamRefTypeLike(TypeParamRef item) {
        return new TypeParamRefTypeNested(item);
    }

    public WildcardRefTypeNested<A> withNewWildcardRefType() {
        return new WildcardRefTypeNested(null);
    }

    public WildcardRefTypeNested<A> withNewWildcardRefTypeLike(WildcardRef item) {
        return new WildcardRefTypeNested(item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A withInitialValue(Optional<Expression> initialValue) {
        this.initialValue = initialValue == null || !initialValue.isPresent() ? Optional.empty() : initialValue;
        return (A)((Object)this);
    }

    public A withInitialValue(Expression initialValue) {
        this.initialValue = initialValue == null ? Optional.empty() : Optional.of(initialValue);
        return (A)((Object)this);
    }

    public Optional<Expression> getInitialValue() {
        return this.initialValue;
    }

    public boolean hasInitialValue() {
        return this.initialValue != null && this.initialValue.isPresent();
    }

    public boolean isEnumConstant() {
        return this.enumConstant;
    }

    public A withEnumConstant(boolean enumConstant) {
        this.enumConstant = enumConstant;
        return (A)((Object)this);
    }

    public boolean hasEnumConstant() {
        return true;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public A withSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
        return (A)((Object)this);
    }

    public boolean hasSynthetic() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertyFluent that = (PropertyFluent)((Object)o);
        if (!Objects.equals(this.comments, that.comments)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.typeRef, that.typeRef)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.initialValue, that.initialValue)) {
            return false;
        }
        if (this.enumConstant != that.enumConstant) {
            return false;
        }
        return this.synthetic == that.synthetic;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.comments, this.annotations, this.typeRef, this.name, this.initialValue, this.enumConstant, this.synthetic, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append("comments:");
            sb.append(String.valueOf(this.comments) + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.typeRef != null) {
            sb.append("typeRef:");
            sb.append(String.valueOf(this.typeRef) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.initialValue != null) {
            sb.append("initialValue:");
            sb.append(String.valueOf(this.initialValue) + ",");
        }
        sb.append("enumConstant:");
        sb.append(this.enumConstant + ",");
        sb.append("synthetic:");
        sb.append(this.synthetic);
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.sundr.model.ClassRef": {
                return new ClassRefBuilder((ClassRef)item);
            }
            case "io.sundr.model.PrimitiveRef": {
                return new PrimitiveRefBuilder((PrimitiveRef)item);
            }
            case "io.sundr.model.VoidRef": {
                return new VoidRefBuilder((VoidRef)item);
            }
            case "io.sundr.model.TypeParamRef": {
                return new TypeParamRefBuilder((TypeParamRef)item);
            }
            case "io.sundr.model.WildcardRef": {
                return new WildcardRefBuilder((WildcardRef)item);
            }
        }
        return PropertyFluent.builderOf((Object)item);
    }

    public A withEnumConstant() {
        return this.withEnumConstant(true);
    }

    public A withSynthetic() {
        return this.withSynthetic(true);
    }

    public class AnnotationsNested<N>
    extends AnnotationRefFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationRefBuilder builder;
        int index;

        AnnotationsNested(int index, AnnotationRef item) {
            this.index = index;
            this.builder = new AnnotationRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }

    public class ClassRefTypeNested<N>
    extends ClassRefFluent<ClassRefTypeNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;

        ClassRefTypeNested(ClassRef item) {
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endClassRefType() {
            return this.and();
        }
    }

    public class PrimitiveRefTypeNested<N>
    extends PrimitiveRefFluent<PrimitiveRefTypeNested<N>>
    implements Nested<N> {
        PrimitiveRefBuilder builder;

        PrimitiveRefTypeNested(PrimitiveRef item) {
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endPrimitiveRefType() {
            return this.and();
        }
    }

    public class VoidRefTypeNested<N>
    extends VoidRefFluent<VoidRefTypeNested<N>>
    implements Nested<N> {
        VoidRefBuilder builder;

        VoidRefTypeNested(VoidRef item) {
            this.builder = new VoidRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endVoidRefType() {
            return this.and();
        }
    }

    public class TypeParamRefTypeNested<N>
    extends TypeParamRefFluent<TypeParamRefTypeNested<N>>
    implements Nested<N> {
        TypeParamRefBuilder builder;

        TypeParamRefTypeNested(TypeParamRef item) {
            this.builder = new TypeParamRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endTypeParamRefType() {
            return this.and();
        }
    }

    public class WildcardRefTypeNested<N>
    extends WildcardRefFluent<WildcardRefTypeNested<N>>
    implements Nested<N> {
        WildcardRefBuilder builder;

        WildcardRefTypeNested(WildcardRef item) {
            this.builder = new WildcardRefBuilder(this, item);
        }

        public N and() {
            return (N)PropertyFluent.this.withTypeRef((TypeRef)this.builder.build());
        }

        public N endWildcardRefType() {
            return this.and();
        }
    }
}

