/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.builder.VisitableBuilder;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluent;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.PrimitiveRefFluent;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeParamRefFluent;
import io.sundr.model.TypeRef;
import io.sundr.model.TypeRefFluent;
import io.sundr.model.VoidRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.VoidRefFluent;
import io.sundr.model.WildcardRef;
import io.sundr.model.WildcardRefBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class WildcardRefFluent<A extends WildcardRefFluent<A>>
extends TypeRefFluent<A> {
    private WildcardRef.BoundKind boundKind;
    private ArrayList<VisitableBuilder<? extends TypeRef, ?>> bounds = new ArrayList();

    public WildcardRefFluent() {
    }

    public WildcardRefFluent(WildcardRef instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WildcardRef instance) {
        WildcardRef wildcardRef = instance = instance != null ? instance : new WildcardRef();
        if (instance != null) {
            this.withBoundKind(instance.getBoundKind());
            this.withBounds(instance.getBounds());
            this.withAttributes(instance.getAttributes());
        }
    }

    public WildcardRef.BoundKind getBoundKind() {
        return this.boundKind;
    }

    public A withBoundKind(WildcardRef.BoundKind boundKind) {
        this.boundKind = boundKind;
        return (A)((Object)this);
    }

    public boolean hasBoundKind() {
        return this.boundKind != null;
    }

    public A addToBounds(VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        this._visitables.get((Object)"bounds").add(builder);
        this.bounds.add(builder);
        return (A)((Object)this);
    }

    public A addToBounds(int index, VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        if (index < 0 || index >= this.bounds.size()) {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        } else {
            this._visitables.get((Object)"bounds").add(index, builder);
            this.bounds.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBounds(int index, TypeRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        VisitableBuilder builder = WildcardRefFluent.builder(item);
        if (index < 0 || index >= this.bounds.size()) {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        } else {
            this._visitables.get((Object)"bounds").add(index, builder);
            this.bounds.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBounds(int index, TypeRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        VisitableBuilder builder = WildcardRefFluent.builder(item);
        if (index < 0 || index >= this.bounds.size()) {
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        } else {
            this._visitables.get((Object)"bounds").set(index, builder);
            this.bounds.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBounds(TypeRef ... items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = WildcardRefFluent.builder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBounds(Collection<TypeRef> items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = WildcardRefFluent.builder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBounds(VisitableBuilder<? extends TypeRef, ?> builder) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        this._visitables.get((Object)"bounds").remove(builder);
        this.bounds.remove(builder);
        return (A)((Object)this);
    }

    public A removeFromBounds(TypeRef ... items) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = WildcardRefFluent.builder(item);
            this._visitables.get((Object)"bounds").remove(builder);
            this.bounds.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBounds(Collection<TypeRef> items) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        for (TypeRef item : items) {
            VisitableBuilder builder = WildcardRefFluent.builder(item);
            this._visitables.get((Object)"bounds").remove(builder);
            this.bounds.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBounds(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        if (this.bounds == null) {
            return (A)((Object)this);
        }
        Iterator<VisitableBuilder<TypeRef, ?>> each = this.bounds.iterator();
        List visitables = this._visitables.get((Object)"bounds");
        while (each.hasNext()) {
            VisitableBuilder<? extends TypeRef, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TypeRef> buildBounds() {
        return WildcardRefFluent.build(this.bounds);
    }

    public TypeRef buildBound(int index) {
        return (TypeRef)this.bounds.get(index).build();
    }

    public TypeRef buildFirstBound() {
        return (TypeRef)this.bounds.get(0).build();
    }

    public TypeRef buildLastBound() {
        return (TypeRef)this.bounds.get(this.bounds.size() - 1).build();
    }

    public TypeRef buildMatchingBound(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        for (VisitableBuilder<? extends TypeRef, ?> visitableBuilder : this.bounds) {
            if (!predicate.test(visitableBuilder)) continue;
            return (TypeRef)visitableBuilder.build();
        }
        return null;
    }

    public boolean hasMatchingBound(Predicate<VisitableBuilder<? extends TypeRef, ?>> predicate) {
        for (VisitableBuilder<? extends TypeRef, ?> visitableBuilder : this.bounds) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    public A withBounds(List<TypeRef> bounds) {
        if (bounds != null) {
            this.bounds = new ArrayList();
            for (TypeRef item : bounds) {
                this.addToBounds(item);
            }
        } else {
            this.bounds = null;
        }
        return (A)((Object)this);
    }

    public A withBounds(TypeRef ... bounds) {
        if (this.bounds != null) {
            this.bounds.clear();
            this._visitables.remove((Object)"bounds");
        }
        if (bounds != null) {
            for (TypeRef item : bounds) {
                this.addToBounds(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBounds() {
        return this.bounds != null && !this.bounds.isEmpty();
    }

    public ClassRefBoundsNested<A> addNewClassRefBound() {
        return new ClassRefBoundsNested(-1, null);
    }

    public ClassRefBoundsNested<A> addNewClassRefBoundLike(ClassRef item) {
        return new ClassRefBoundsNested(-1, item);
    }

    public ClassRefBoundsNested<A> setNewClassRefBoundLike(int index, ClassRef item) {
        return new ClassRefBoundsNested(index, item);
    }

    public PrimitiveRefBoundsNested<A> addNewPrimitiveRefBound() {
        return new PrimitiveRefBoundsNested(-1, null);
    }

    public PrimitiveRefBoundsNested<A> addNewPrimitiveRefBoundLike(PrimitiveRef item) {
        return new PrimitiveRefBoundsNested(-1, item);
    }

    public PrimitiveRefBoundsNested<A> setNewPrimitiveRefBoundLike(int index, PrimitiveRef item) {
        return new PrimitiveRefBoundsNested(index, item);
    }

    public VoidRefBoundsNested<A> addNewVoidRefBound() {
        return new VoidRefBoundsNested(-1, null);
    }

    public VoidRefBoundsNested<A> addNewVoidRefBoundLike(VoidRef item) {
        return new VoidRefBoundsNested(-1, item);
    }

    public VoidRefBoundsNested<A> setNewVoidRefBoundLike(int index, VoidRef item) {
        return new VoidRefBoundsNested(index, item);
    }

    public TypeParamRefBoundsNested<A> addNewTypeParamRefBound() {
        return new TypeParamRefBoundsNested(-1, null);
    }

    public TypeParamRefBoundsNested<A> addNewTypeParamRefBoundLike(TypeParamRef item) {
        return new TypeParamRefBoundsNested(-1, item);
    }

    public TypeParamRefBoundsNested<A> setNewTypeParamRefBoundLike(int index, TypeParamRef item) {
        return new TypeParamRefBoundsNested(index, item);
    }

    public WildcardRefBoundsNested<A> addNewWildcardRefBound() {
        return new WildcardRefBoundsNested(-1, null);
    }

    public WildcardRefBoundsNested<A> addNewWildcardRefBoundLike(WildcardRef item) {
        return new WildcardRefBoundsNested(-1, item);
    }

    public WildcardRefBoundsNested<A> setNewWildcardRefBoundLike(int index, WildcardRef item) {
        return new WildcardRefBoundsNested(index, item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WildcardRefFluent that = (WildcardRefFluent)((Object)o);
        if (!Objects.equals(this.boundKind, that.boundKind)) {
            return false;
        }
        return Objects.equals(this.bounds, that.bounds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.boundKind, this.bounds, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.boundKind != null) {
            sb.append("boundKind:");
            sb.append(String.valueOf(this.boundKind) + ",");
        }
        if (this.bounds != null && !this.bounds.isEmpty()) {
            sb.append("bounds:");
            sb.append(this.bounds);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.sundr.model.ClassRef": {
                return new ClassRefBuilder((ClassRef)item);
            }
            case "io.sundr.model.PrimitiveRef": {
                return new PrimitiveRefBuilder((PrimitiveRef)item);
            }
            case "io.sundr.model.VoidRef": {
                return new VoidRefBuilder((VoidRef)item);
            }
            case "io.sundr.model.TypeParamRef": {
                return new TypeParamRefBuilder((TypeParamRef)item);
            }
            case "io.sundr.model.WildcardRef": {
                return new WildcardRefBuilder((WildcardRef)item);
            }
        }
        return WildcardRefFluent.builderOf((Object)item);
    }

    public class ClassRefBoundsNested<N>
    extends ClassRefFluent<ClassRefBoundsNested<N>>
    implements Nested<N> {
        ClassRefBuilder builder;
        int index;

        ClassRefBoundsNested(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        public N and() {
            return (N)WildcardRefFluent.this.setToBounds(this.index, (TypeRef)this.builder.build());
        }

        public N endClassRefBound() {
            return this.and();
        }
    }

    public class PrimitiveRefBoundsNested<N>
    extends PrimitiveRefFluent<PrimitiveRefBoundsNested<N>>
    implements Nested<N> {
        PrimitiveRefBuilder builder;
        int index;

        PrimitiveRefBoundsNested(int index, PrimitiveRef item) {
            this.index = index;
            this.builder = new PrimitiveRefBuilder(this, item);
        }

        public N and() {
            return (N)WildcardRefFluent.this.setToBounds(this.index, (TypeRef)this.builder.build());
        }

        public N endPrimitiveRefBound() {
            return this.and();
        }
    }

    public class VoidRefBoundsNested<N>
    extends VoidRefFluent<VoidRefBoundsNested<N>>
    implements Nested<N> {
        VoidRefBuilder builder;
        int index;

        VoidRefBoundsNested(int index, VoidRef item) {
            this.index = index;
            this.builder = new VoidRefBuilder(this, item);
        }

        public N and() {
            return (N)WildcardRefFluent.this.setToBounds(this.index, (TypeRef)this.builder.build());
        }

        public N endVoidRefBound() {
            return this.and();
        }
    }

    public class TypeParamRefBoundsNested<N>
    extends TypeParamRefFluent<TypeParamRefBoundsNested<N>>
    implements Nested<N> {
        TypeParamRefBuilder builder;
        int index;

        TypeParamRefBoundsNested(int index, TypeParamRef item) {
            this.index = index;
            this.builder = new TypeParamRefBuilder(this, item);
        }

        public N and() {
            return (N)WildcardRefFluent.this.setToBounds(this.index, (TypeRef)this.builder.build());
        }

        public N endTypeParamRefBound() {
            return this.and();
        }
    }

    public class WildcardRefBoundsNested<N>
    extends WildcardRefFluent<WildcardRefBoundsNested<N>>
    implements Nested<N> {
        WildcardRefBuilder builder;
        int index;

        WildcardRefBoundsNested(int index, WildcardRef item) {
            this.index = index;
            this.builder = new WildcardRefBuilder(this, item);
        }

        public N and() {
            return (N)WildcardRefFluent.this.setToBounds(this.index, (TypeRef)this.builder.build());
        }

        public N endWildcardRefBound() {
            return this.and();
        }
    }
}

