/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.Kind;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.WildcardRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.model.utils.Collections;
import io.sundr.utils.Patterns;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Types {
    public static final String PACKAGE = ".*package\\s+(.*)\\s*\\;";
    public static final String CLASS_NAME = ".*(enum|class|interface)\\s+(\\w+).*\\W*\\{";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String JAVA_UTIL_OPTIONAL_INT = "java.util.OptionalInt";
    private static final String JAVA_UTIL_OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    private static final String JAVA_UTIL_OPTIONAL_LONG = "java.util.OptionalLong";
    private static final String OTHER = "other";
    private static final String DOT_REGEX = "\\.";
    public static final TypeParamDef F = Types.newTypeParamDef("F");
    public static final TypeParamDef I = Types.newTypeParamDef("I");
    public static final TypeParamDef O = Types.newTypeParamDef("O");
    public static final TypeParamDef B = Types.newTypeParamDef("B");
    public static final TypeParamDef T = Types.newTypeParamDef("T");
    public static final TypeParamRef T_REF = Types.newTypeParamRef("T");
    public static final TypeParamDef N = Types.newTypeParamDef("N");
    public static final TypeParamRef N_REF = Types.newTypeParamRef("N");
    public static final TypeParamDef V = Types.newTypeParamDef("V");
    public static final VoidRef VOID = new VoidRef();
    public static final WildcardRef Q = new WildcardRef();
    public static final TypeDef TYPE = TypeDef.forName((String)Type.class.getName());
    public static final TypeDef CLASS = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(TypeDef.forName((String)Class.class.getName())).withKind(Kind.INTERFACE)).withParameters(new TypeParamDef[]{T})).withExtendsList(new ClassRef[]{TYPE.toInternalReference()})).build();
    public static final ClassRef CLASS_REF_NO_ARG = ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(CLASS.getFullyQualifiedName())).build();
    public static final TypeDef ARRAY = TypeDef.forName((String)Array.class.getName());
    public static final TypeDef TYPE_VARIABLE = TypeDef.forName((String)TypeVariable.class.getName());
    public static final TypeDef GENERIC_ARRAY_TYPE = TypeDef.forName((String)GenericArrayType.class.getName());
    public static final TypeDef PARAMETERIZED_TYPE = TypeDef.forName((String)ParameterizedType.class.getName());
    public static final TypeDef OBJECT = TypeDef.OBJECT;
    public static final ClassRef OBJECT_REF = OBJECT.toInternalReference();
    public static final TypeDef STRING = TypeDef.forName((String)String.class.getName());
    public static final ClassRef STRING_REF = STRING.toReference(new TypeRef[0]);
    public static final TypeDef BOOLEAN = TypeDef.forName((String)Boolean.class.getName());
    public static final TypeRef BOOLEAN_REF = BOOLEAN.toInternalReference();
    public static final TypeDef BYTE = TypeDef.forName((String)Byte.class.getName());
    public static final ClassRef BYTE_REF = BYTE.toInternalReference();
    public static final TypeDef CHARACTER = TypeDef.forName((String)Character.class.getName());
    public static final ClassRef CHARACTER_REF = CHARACTER.toInternalReference();
    public static final TypeDef SHORT = TypeDef.forName((String)Short.class.getName());
    public static final ClassRef SHORT_REF = SHORT.toInternalReference();
    public static final TypeDef INT = TypeDef.forName((String)Integer.class.getName());
    public static final ClassRef INT_REF = INT.toInternalReference();
    public static final TypeDef LONG = TypeDef.forName((String)Long.class.getName());
    public static final ClassRef LONG_REF = LONG.toInternalReference();
    public static final TypeDef DOUBLE = TypeDef.forName((String)Double.class.getName());
    public static final ClassRef DOUBLE_REF = DOUBLE.toInternalReference();
    public static final TypeDef FLOAT = TypeDef.forName((String)Float.class.getName());
    public static final ClassRef FLOAT_REF = FLOAT.toInternalReference();
    public static final TypeDef OPTIONAL = ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder(TypeDef.forName((String)Optional.class.getName())).withKind(Kind.CLASS)).withParameters(new TypeParamDef[]{T})).build();
    public TypeRef OPTIONAL_REF = OPTIONAL.toInternalReference();
    public static final PrimitiveRef PRIMITIVE_BOOLEAN_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("boolean")).build();
    public static final PrimitiveRef PRIMITIVE_BYTE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("byte")).build();
    public static final PrimitiveRef PRIMITIVE_CHAR_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("char")).build();
    public static final PrimitiveRef PRIMITIVE_SHORT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("short")).build();
    public static final PrimitiveRef PRIMITIVE_INT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("int")).build();
    public static final PrimitiveRef PRIMITIVE_LONG_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("long")).build();
    public static final PrimitiveRef PRIMITIVE_DOUBLE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("double")).build();
    public static final PrimitiveRef PRIMITIVE_FLOAT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("float")).build();
    public static TypeRef[] PRIMITIVE_TYPES = new TypeRef[]{PRIMITIVE_BOOLEAN_REF, PRIMITIVE_BYTE_REF, PRIMITIVE_CHAR_REF, PRIMITIVE_SHORT_REF, PRIMITIVE_INT_REF, PRIMITIVE_LONG_REF, PRIMITIVE_DOUBLE_REF, PRIMITIVE_FLOAT_REF};
    public static TypeRef[] BOXED_PRIMITIVE_TYPES = new TypeRef[]{BOOLEAN_REF, BYTE_REF, CHARACTER_REF, SHORT_REF, INT_REF, LONG_REF, DOUBLE_REF, FLOAT_REF};
    public static String[] BOXED_PARSE_METHOD = new String[]{"parseBoolean", "parseByte", null, "parseShort", "parseInt", "parseLong", "parseDouble", "parseFloat"};

    private Types() {
    }

    public static TypeRef box(TypeRef ref) {
        if (ref instanceof PrimitiveRef) {
            int index = 0;
            for (TypeRef primitive : PRIMITIVE_TYPES) {
                if (primitive.equals(ref)) {
                    return BOXED_PRIMITIVE_TYPES[index];
                }
                ++index;
            }
        }
        return ref;
    }

    public static boolean isInstanceOf(TypeRef type, TypeDef targetType, Function<TypeRef, Boolean> function) {
        if (type instanceof ClassRef) {
            ClassRef classRef = (ClassRef)type;
            if (classRef.getFullyQualifiedName().equals(targetType.getFullyQualifiedName())) {
                return true;
            }
            if (type.equals(TypeDef.OBJECT.toInternalReference())) {
                return false;
            }
            TypeDef definition = (TypeDef)classRef.map((Function)GetDefinition.FUNCTION);
            for (TypeRef i : definition.getImplementsList()) {
                if (!function.apply(i).booleanValue()) continue;
                return true;
            }
            for (TypeRef e : definition.getExtendsList()) {
                if (!function.apply(e).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeParamDef getParameterDefinition(TypeRef typeRef, Collection<TypeParamDef> parameters) {
        String name = typeRef instanceof ClassRef ? ((ClassRef)typeRef).getFullyQualifiedName() : (typeRef instanceof TypeParamRef ? ((TypeParamRef)typeRef).getName() : (typeRef instanceof PrimitiveRef ? ((PrimitiveRef)typeRef).getName() : typeRef.toString()));
        for (TypeParamDef parameter : parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static TypeParamRef newTypeParamRef(String letter) {
        return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(letter)).build();
    }

    public static TypeParamDef newTypeParamDef(String letter) {
        return ((TypeParamDefBuilder)new TypeParamDefBuilder().withName(letter)).build();
    }

    public static TypeDef unwrapGeneric(TypeDef base) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(new TypeParamDef[0])).build();
    }

    public static TypeDef typeGenericOf(TypeDef base, TypeParamDef ... parameters) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withParameters(parameters)).build();
    }

    public static TypeDef typeExtends(TypeDef base, ClassRef superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withExtendsList(new ClassRef[]{superClass})).build();
    }

    public static TypeDef typeImplements(TypeDef base, ClassRef ... superClass) {
        return ((TypeDefBuilder)new TypeDefBuilder(base).withImplementsList(superClass)).build();
    }

    public static String fullyQualifiedNameDiff(String left, String right) {
        String[] lparts = left.split(DOT_REGEX);
        String[] rparts = right.split(DOT_REGEX);
        int l = lparts.length - 1;
        for (int r = rparts.length - 1; l >= 0 && r >= 0; --r, --l) {
            if (lparts[l].equals(rparts[r])) continue;
            return rparts[r];
        }
        return OTHER;
    }

    public static boolean isEnum(TypeRef typeRef) {
        if (typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            return ((TypeDef)classRef.map((Function)GetDefinition.FUNCTION)).isEnum();
        }
        return false;
    }

    public static boolean isAbstract(TypeRef typeRef) {
        DefinitionRepository repository = DefinitionRepository.getRepository();
        TypeDef def = repository.getDefinition(typeRef);
        if (def == null && typeRef instanceof ClassRef) {
            def = (TypeDef)((ClassRef)typeRef).map((Function)GetDefinition.FUNCTION);
        }
        return def != null ? def.isAbstract() : false;
    }

    public static boolean isConcrete(TypeRef typeRef) {
        DefinitionRepository repository = DefinitionRepository.getRepository();
        TypeDef def = repository.getDefinition(typeRef);
        if (def == null && typeRef instanceof ClassRef) {
            def = (TypeDef)((ClassRef)typeRef).map((Function)GetDefinition.FUNCTION);
        }
        return def != null ? !def.isAbstract() && !def.isInterface() : false;
    }

    public static boolean isPrimitive(TypeRef type) {
        return type instanceof PrimitiveRef;
    }

    public static boolean isMap(TypeRef type) {
        return Collections.IS_MAP.apply(type);
    }

    public static boolean isList(TypeRef type) {
        return Collections.IS_LIST.apply(type);
    }

    public static boolean isSet(TypeRef type) {
        return Collections.IS_SET.apply(type);
    }

    public static boolean isCollection(TypeRef type) {
        return Collections.IS_COLLECTION.apply(type);
    }

    public static boolean isBoolean(TypeRef type) {
        if (type instanceof PrimitiveRef) {
            return PRIMITIVE_BOOLEAN_REF.getName().equals(((PrimitiveRef)type).getName());
        }
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return BOOLEAN_REF.equals(type);
    }

    public static boolean isArray(TypeRef type) {
        if (type instanceof ClassRef) {
            return ((ClassRef)type).getDimensions() > 0;
        }
        if (type instanceof PrimitiveRef) {
            return ((PrimitiveRef)type).getDimensions() > 0;
        }
        if (type instanceof TypeParamRef) {
            return ((TypeParamRef)type).getDimensions() > 0;
        }
        return false;
    }

    public static boolean isOptional(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalInt(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_INT.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalDouble(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_DOUBLE.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isOptionalLong(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return JAVA_UTIL_OPTIONAL_LONG.equals(((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getFullyQualifiedName());
    }

    public static boolean isJdkType(TypeRef type) {
        if (!(type instanceof ClassRef)) {
            return false;
        }
        String packageName = ((TypeDef)((ClassRef)type).map((Function)GetDefinition.FUNCTION)).getPackageName();
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (packageName.startsWith("sun.")) {
            return true;
        }
        if (packageName.startsWith("com.sun.")) {
            return true;
        }
        return packageName.startsWith("com.ibm.jit.");
    }

    public static boolean hasMethod(TypeDef typeDef, String method) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getMethods().stream()).filter(m -> method.equals(m.getName())).findAny().isPresent();
    }

    public static boolean hasProperty(TypeDef typeDef, String property) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getProperties().stream()).filter(p -> property.equals(p.getName())).findAny().isPresent();
    }

    public static List<Property> allProperties(TypeDef typeDef) {
        return Types.unrollHierarchy(typeDef).stream().flatMap(h -> h.getProperties().stream()).collect(Collectors.toList());
    }

    public static Set<TypeDef> unrollHierarchy(TypeDef typeDef) {
        if (OBJECT.equals((Object)typeDef)) {
            return new HashSet<TypeDef>();
        }
        HashSet<TypeDef> hierarchy = new HashSet<TypeDef>();
        hierarchy.add(typeDef);
        hierarchy.addAll(typeDef.getExtendsList().stream().flatMap(s -> Types.unrollHierarchy((TypeDef)s.map((Function)GetDefinition.FUNCTION)).stream()).collect(Collectors.toSet()));
        return hierarchy;
    }

    public static String toClassName(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ClassRef) {
            return ((ClassRef)o).getFullyQualifiedName();
        }
        if (o instanceof TypeDef) {
            return ((TypeDef)o).getFullyQualifiedName();
        }
        return String.valueOf(o);
    }

    public static void visitParents(TypeDef type, List<TypeDef> types) {
        Types.visitParents(type, types, new ArrayList<TypeDef>());
    }

    public static void visitParents(TypeDef type, List<TypeDef> types, List<TypeDef> visited) {
        if (type == null || JAVA_LANG_OBJECT.equals(type.getFullyQualifiedName())) {
            return;
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        ArrayList allRefs = new ArrayList();
        allRefs.addAll(type.getImplementsList());
        allRefs.addAll(type.getExtendsList());
        for (TypeRef ref : allRefs) {
            TypeDef parent = DefinitionRepository.getRepository().getDefinition(ref);
            Types.visitParents(parent, types, visited);
        }
        types.add(type);
    }

    public static Optional<String> parsePackage(String content) {
        return Patterns.match((String)content, (String)PACKAGE);
    }

    public static Optional<String> parseName(String content) {
        return Patterns.match((String)content, (String)CLASS_NAME, (int)2);
    }

    public static String parseFullyQualifiedName(String content) {
        Optional<String> pkg = Types.parsePackage(content);
        String name = Types.parseName(content).orElseThrow(() -> new IllegalStateException("Cannot extract fully qualified name from generated code."));
        return pkg.map(p -> p + "." + name).orElse(name);
    }
}

