/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Statement;
import io.sundr.model.Switch;
import io.sundr.model.ValueRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SwitchDslCaseStep
implements Statement {
    private Expression expression;
    private Map<ValueRef, Block> cases;

    SwitchDslCaseStep(Expression expression) {
        this.expression = expression;
        this.cases = new LinkedHashMap<ValueRef, Block>();
    }

    SwitchDslCaseStep(Expression expression, Map<ValueRef, Block> cases) {
        this.expression = expression;
        this.cases = new LinkedHashMap<ValueRef, Block>(cases);
    }

    public SwitchDslCaseStep inCase(Object key, Statement ... statements) {
        ValueRef keyRef = key instanceof ValueRef ? (ValueRef)key : ValueRef.from(key, new Object[0]);
        this.cases.put(keyRef, new Block(Arrays.asList(statements)));
        return this;
    }

    public SwitchDslCaseStep inCase(ValueRef key, Statement ... statements) {
        this.cases.put(key, new Block(Arrays.asList(statements)));
        return this;
    }

    public SwitchDslCaseStep inCase(Object key, List<Statement> statements) {
        ValueRef keyRef = key instanceof ValueRef ? (ValueRef)key : ValueRef.from(key, new Object[0]);
        this.cases.put(keyRef, new Block(statements));
        return this;
    }

    public SwitchDslCaseStep inCase(ValueRef key, List<Statement> statements) {
        this.cases.put(key, new Block(statements));
        return this;
    }

    public SwitchDslCaseStep inCase(Object key, Block block) {
        ValueRef keyRef = key instanceof ValueRef ? (ValueRef)key : ValueRef.from(key, new Object[0]);
        this.cases.put(keyRef, block);
        return this;
    }

    public SwitchDslCaseStep inCase(ValueRef key, Block block) {
        this.cases.put(key, block);
        return this;
    }

    public SwitchDslCaseStep cases(Map<ValueRef, Block> additionalCases) {
        this.cases.putAll(additionalCases);
        return this;
    }

    public Switch defaultCase(Statement ... statements) {
        return new Switch(this.expression, this.cases, Optional.of(new Block(Arrays.asList(statements))));
    }

    public Switch defaultCase(List<Statement> statements) {
        return new Switch(this.expression, this.cases, Optional.of(new Block(statements)));
    }

    public Switch defaultCase(Block block) {
        return new Switch(this.expression, this.cases, Optional.of(block));
    }

    public Switch end() {
        return new Switch(this.expression, this.cases, Optional.empty());
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.expression != null) {
            refs.addAll(this.expression.getReferences());
        }
        if (this.cases != null) {
            for (Map.Entry<ValueRef, Block> entry : this.cases.entrySet()) {
                if (entry.getKey() != null) {
                    refs.addAll(entry.getKey().getReferences());
                }
                if (entry.getValue() == null) continue;
                refs.addAll(entry.getValue().getReferences());
            }
        }
        return refs;
    }

    @Override
    public String render() {
        return this.end().render();
    }
}

