/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Cast;
import io.sundr.model.ClassRef;
import io.sundr.model.Construct;
import io.sundr.model.Expression;
import io.sundr.model.MethodCall;
import io.sundr.model.Property;
import io.sundr.model.ReturnDslThisStep;
import io.sundr.model.ReturnDslVariableStep;
import io.sundr.model.Statement;
import io.sundr.model.This;
import io.sundr.model.ValueRef;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Return
implements Statement {
    private final Expression expression;

    public static Return True() {
        return new Return(new ValueRef(true));
    }

    public static Return False() {
        return new Return(new ValueRef(false));
    }

    public static Return newInstance(ClassRef type, Expression ... arguments) {
        return new Return(new Construct(type, arguments));
    }

    public static Return newInstance(ClassRef type, List<Expression> arguments) {
        return new Return(new Construct(type, arguments));
    }

    public static Return newInstance(Class type, Expression ... arguments) {
        return new Return(new Construct(type, arguments));
    }

    public static Return newInstance(Class type, List<Expression> arguments) {
        return new Return(new Construct(type, arguments));
    }

    public static ReturnDslThisStep This() {
        return new ReturnDslThisStep();
    }

    public static Return This(ClassRef castTo) {
        return new Return(new Cast(castTo, (Expression)new This()));
    }

    public static ReturnDslVariableStep variable(Property property) {
        return new ReturnDslVariableStep(property);
    }

    public static ReturnDslVariableStep variable(String variableName) {
        return new ReturnDslVariableStep(variableName);
    }

    public static Return call(String method, Expression ... arguments) {
        return new Return(new MethodCall(method, (Expression)null, arguments));
    }

    public static Return value(Object value) {
        return new Return(ValueRef.from(value, new Object[0]));
    }

    public static Return Null() {
        return new Return(ValueRef.NULL);
    }

    public Return(Expression expression) {
        this.expression = expression;
    }

    public Return(Property property) {
        this(property.toReference());
    }

    public Return(Object object) {
        this(ValueRef.from(object, new Object[0]));
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        refs.addAll(this.expression.getReferences());
        return refs;
    }

    @Override
    public String render() {
        return "return " + this.expression.renderExpression() + ";";
    }
}

