/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Annotatable;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Commentable;
import io.sundr.model.Kind;
import io.sundr.model.ModifierSupport;
import io.sundr.model.Modifiers;
import io.sundr.model.Nameable;
import io.sundr.model.Property;
import io.sundr.model.Renderable;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import io.sundr.model.WithReferences;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Method
extends ModifierSupport
implements Renderable,
WithReferences,
Commentable,
Annotatable {
    public static final String DEFAULT = "default";
    private final List<String> comments;
    private final List<AnnotationRef> annotations;
    private final List<TypeParamDef> parameters;
    private final String name;
    private final TypeRef returnType;
    private final List<Property> arguments;
    private final boolean varArgPreferred;
    private final List<ClassRef> exceptions;
    private final boolean defaultMethod;
    private final Block block;

    public Method(List<String> comments, List<AnnotationRef> annotations, List<TypeParamDef> parameters, String name, TypeRef returnType, List<Property> arguments, boolean varArgPreferred, List<ClassRef> exceptions, boolean defaultMethod, Block block, Modifiers modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.comments = comments != null ? comments : Collections.emptyList();
        this.annotations = annotations;
        this.parameters = parameters;
        this.name = name;
        this.returnType = returnType;
        this.arguments = arguments;
        this.varArgPreferred = varArgPreferred;
        this.exceptions = exceptions;
        this.defaultMethod = defaultMethod;
        this.block = block;
    }

    public static Method newMethod(String name, TypeRef returnType, boolean varArgPrefered, Property ... arguments) {
        return new Method(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), name, returnType, Arrays.asList(arguments), varArgPrefered, Collections.emptyList(), false, null, Modifiers.create(), new HashMap<AttributeKey, Object>());
    }

    public static Method newMethod(String name, TypeRef returnType, Property ... arguments) {
        return Method.newMethod(name, returnType, false, arguments);
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    public boolean isVarArgPreferred() {
        return this.varArgPreferred;
    }

    public List<TypeParamDef> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public TypeRef getReturnType() {
        return this.returnType;
    }

    public List<Property> getArguments() {
        return this.arguments;
    }

    public List<ClassRef> getExceptions() {
        return this.exceptions;
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public Block getBlock() {
        return this.block;
    }

    public Method withErasure() {
        return new Method(this.comments, this.annotations, this.parameters, this.name, this.returnType, this.arguments.stream().map(Property::withErasure).collect(Collectors.toList()), this.varArgPreferred, this.exceptions, this.defaultMethod, this.block, this.modifiers, this.getAttributes());
    }

    @Override
    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        for (AnnotationRef annotationRef : this.annotations) {
            refs.addAll(annotationRef.getReferences());
        }
        if (this.returnType instanceof ClassRef) {
            Iterator<AttributeSupport> classRef = (ClassRef)this.returnType;
            refs.addAll(((ClassRef)((Object)classRef)).getReferences());
        }
        for (Property argument : this.arguments) {
            refs.addAll(argument.getReferences());
        }
        for (ClassRef e : this.exceptions) {
            refs.addAll(e.getReferences());
        }
        for (AnnotationRef a : this.getAnnotations()) {
            refs.addAll(a.getClassRef().getReferences());
        }
        for (TypeParamDef typeParamDef : this.parameters) {
            for (ClassRef bound : typeParamDef.getBounds()) {
                refs.addAll(bound.getReferences());
            }
        }
        if (this.block != null) {
            refs.addAll(this.block.getReferences());
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
            return false;
        }
        if (!this.modifiers.equals(other.modifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        sb.append(this.arguments.stream().map(a -> a.withoutModiers().render()).collect(Collectors.joining(",")));
        sb.append(")");
        return sb.toString();
    }

    public String renderDefinition(TypeDef enclosingType) {
        StringBuilder sb = new StringBuilder();
        this.renderDefinition(sb, enclosingType);
        return sb.toString();
    }

    public void renderDefinition(StringBuilder sb, TypeDef enclosingType) {
        if (this.isDefaultMethod()) {
            sb.append(DEFAULT).append(" ");
        } else {
            this.renderModifiers(sb);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(this.parameters.stream().map(p -> p.render()).collect(Collectors.joining(",")));
            sb.append(">");
        }
        if (this.name != null) {
            sb.append(this.returnType.render());
            sb.append(" ").append(this.name);
        } else if (enclosingType != null && enclosingType.getFullyQualifiedName().equals(((ClassRef)this.returnType).getFullyQualifiedName())) {
            sb.append(enclosingType.getName());
        } else {
            String fqcn = ((ClassRef)this.returnType).getFullyQualifiedName();
            String className = Nameable.getClassName(fqcn);
            sb.append(className);
        }
        sb.append("(");
        if (!this.varArgPreferred) {
            sb.append(this.arguments.stream().map(a -> a.withoutModiers().render()).collect(Collectors.joining(",")));
        } else if (!this.arguments.isEmpty()) {
            List<Property> args = this.arguments.subList(0, this.arguments.size() - 1);
            Property varArg = this.arguments.get(this.arguments.size() - 1);
            sb.append(args.stream().map(a -> a.render()).collect(Collectors.joining(",")));
            if (!args.isEmpty()) {
                sb.append(",");
            }
            if (varArg.getTypeRef().getDimensions() == 1) {
                sb.append(varArg.getTypeRef().withDimensions(0)).append("...").append(" ");
            } else {
                sb.append(varArg.getTypeRef().render()).append(" ");
            }
            sb.append(varArg.getName());
        }
        sb.append(")");
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append(" ").append("throws").append(" ").append(this.exceptions.stream().map(e -> e.render()).collect(Collectors.joining(",")));
        }
    }

    @Override
    public String render() {
        return this.render(null);
    }

    public String render(TypeDef enclosingType) {
        boolean renderBody;
        StringBuilder sb = new StringBuilder();
        this.renderDefinition(sb, enclosingType);
        boolean bl = renderBody = this.isDefaultMethod() || this.isStatic() || enclosingType != null && enclosingType.getKind() != Kind.INTERFACE;
        if (renderBody) {
            sb.append(" ").append("{").append("\n");
            if (this.getBlock() != null) {
                sb.append(this.getBlock().render());
            }
            sb.append("}").append("\n");
        } else {
            sb.append(";");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.comments.isEmpty()) {
            sb.append("\n").append("/**").append("\n");
            for (String c : this.comments) {
                sb.append(" ").append("*").append(" ").append(c).append("\n");
            }
            sb.append(" ").append(" */").append("\n");
        }
        for (AnnotationRef annotationRef : this.annotations) {
            sb.append(annotationRef.toString()).append(" ");
        }
        if (this.isDefaultMethod()) {
            sb.append(DEFAULT).append(" ");
        } else {
            this.renderModifiers(sb);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(this.parameters.stream().map(Object::toString).collect(Collectors.joining(",")));
            sb.append(">");
        }
        if (this.name != null) {
            sb.append(this.returnType);
            sb.append(" ").append(this.name);
        } else {
            String fqcn = ((ClassRef)this.returnType).getFullyQualifiedName();
            String className = fqcn.substring(fqcn.lastIndexOf(".") + 1);
            sb.append(className);
        }
        sb.append("(");
        if (!this.varArgPreferred) {
            sb.append(this.arguments.stream().map(a -> a.withoutModiers().toString()).collect(Collectors.joining(",")));
        } else if (!this.arguments.isEmpty()) {
            List<Property> args = this.arguments.subList(0, this.arguments.size() - 1);
            Property varArg = this.arguments.get(this.arguments.size() - 1);
            sb.append(args.stream().map(Object::toString).collect(Collectors.joining(",")));
            if (!args.isEmpty()) {
                sb.append(",");
            }
            if (varArg.getTypeRef().getDimensions() == 1) {
                sb.append(varArg.getTypeRef().withDimensions(0)).append("...").append(" ");
            } else {
                sb.append(varArg.getTypeRef()).append(" ");
            }
            sb.append(varArg.getName());
        }
        sb.append(")");
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            sb.append(" ").append("throws").append(" ").append(this.exceptions.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }
}

