/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Statement;
import java.util.HashSet;
import java.util.Set;

public class Do
implements Statement {
    private final Expression condition;
    private final Statement statement;

    public Do(Expression condition, Statement statement) {
        this.condition = condition;
        this.statement = statement;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.condition != null) {
            refs.addAll(this.condition.getReferences());
        }
        if (this.statement != null) {
            refs.addAll(this.statement.getReferences());
        }
        return refs;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append("do").append(" ").append("{").append("\n");
        sb.append(this.tab(this.statement.renderStatement()));
        sb.append("}").append(" while ").append("(").append(this.condition.render()).append(")").append(";").append("\n");
        return sb.toString();
    }
}

