/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Block;
import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.If;
import io.sundr.model.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IfDslThenStep
implements Statement {
    private Expression condition;
    private List<Statement> statements;

    public IfDslThenStep(Expression condition, List<Statement> statements) {
        this.condition = condition;
        this.statements = statements;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public Set<ClassRef> getReferences() {
        HashSet<ClassRef> refs = new HashSet<ClassRef>();
        if (this.condition != null) {
            refs.addAll(this.condition.getReferences());
        }
        if (this.statements != null) {
            for (Statement stmt : this.statements) {
                if (stmt == null) continue;
                refs.addAll(stmt.getReferences());
            }
        }
        return refs;
    }

    public If orElse(Statement ... elseStatement) {
        return new If(this.condition, Block.wrap(this.statements), Block.wrap(elseStatement));
    }

    public If orElse(List<Statement> elseStatement) {
        return new If(this.condition, Block.wrap(this.statements), Block.wrap(elseStatement));
    }

    public If end() {
        return new If(this.condition, Block.wrap(this.statements));
    }

    void setCondition(Expression condition) {
        this.condition = condition;
    }

    void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    @Override
    public String render() {
        return this.end().render();
    }
}

