/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;

public class PropertyRef
implements Expression {
    private final Property property;
    private final Expression scope;

    public PropertyRef(Property property, Expression scope) {
        this.property = property;
        this.scope = scope;
    }

    public PropertyRef(TypeRef type, String name, Expression scope) {
        this.property = Property.newProperty(type, name);
        this.scope = scope;
    }

    public PropertyRef(String name, Expression scope) {
        this.property = Property.newProperty(ClassRef.OBJECT, name);
        this.scope = scope;
    }

    public PropertyRef(Property property) {
        this.property = property;
        this.scope = null;
    }

    public Property getProperty() {
        return this.property;
    }

    public Expression getScope() {
        return this.scope;
    }

    @Override
    public String render() {
        if (this.scope != null) {
            return this.scope.renderExpression() + "." + this.property.getName();
        }
        return this.property.getName();
    }
}

