/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.ClassRef;
import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Renderable;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MethodCall
implements ExpressionOrStatement {
    private final String name;
    private final Expression scope;
    private final List<TypeRef> parameters;
    private List<Expression> arguments;

    public MethodCall(String name, Expression scope, List<TypeRef> parameters, List<Expression> arguments) {
        this.name = name;
        this.scope = scope;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public MethodCall(String name, Expression scope, Expression ... arguments) {
        this(name, scope, new ArrayList<TypeRef>(), Arrays.asList(arguments));
    }

    public MethodCall(String name, Expression scope, List<Expression> arguments) {
        this(name, scope, new ArrayList<TypeRef>(), arguments);
    }

    public MethodCall(String name, ClassRef scope, Expression ... arguments) {
        this(name, (Expression)ValueRef.from(scope, new ClassRef[0]), arguments);
    }

    public MethodCall(String name, Class scope, Expression ... arguments) {
        this(name, (Expression)ValueRef.from(ClassRef.forClass(scope), new ClassRef[0]), arguments);
    }

    public MethodCall(String name, Object scope, Expression ... arguments) {
        this(name, (Expression)ValueRef.from(scope, new Object[0]), arguments);
    }

    public String getName() {
        return this.name;
    }

    public Expression getScope() {
        return this.scope;
    }

    public List<TypeRef> getParameters() {
        return this.parameters;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        if (this.scope != null) {
            sb.append(this.scope.renderExpression().replaceAll(Pattern.quote(".class") + "$", "")).append(".");
            if (!this.parameters.isEmpty()) {
                sb.append("<");
                sb.append(this.parameters.stream().map(Renderable::render).collect(Collectors.joining(", ")));
                sb.append(">");
            }
        }
        sb.append(this.name).append("(");
        if (!this.arguments.isEmpty()) {
            sb.append(this.arguments.stream().map(Expression::renderExpression).collect(Collectors.joining(", ")));
        }
        sb.append(")");
        return sb.toString();
    }
}

