/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Expression;
import io.sundr.model.ExpressionOrStatement;
import io.sundr.model.Renderable;
import io.sundr.model.Return;
import io.sundr.model.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Lambda
implements ExpressionOrStatement {
    private final List<String> parameters;
    private final Statement statement;

    public Lambda(List<String> parameters, Statement statement) {
        this.parameters = parameters;
        this.statement = statement;
    }

    public Lambda(String parameter, Statement value) {
        this(Arrays.asList(parameter), value);
    }

    public Lambda(List<String> parameters, Expression expression) {
        this(parameters, (Statement)new Return(expression));
    }

    public Lambda(String parameter, Expression expression) {
        this(Arrays.asList(parameter), (Statement)new Return(expression));
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String render() {
        StringBuilder sb = new StringBuilder();
        if (this.parameters.size() == 1) {
            sb.append(this.parameters.get(0));
        } else {
            sb.append(this.parameters.stream().collect(Collectors.joining(", ", "(", ")")));
        }
        sb.append(" -> ");
        if (this.statement instanceof Return) {
            sb.append(((Return)this.statement).getExpression().renderExpression());
        } else {
            sb.append(Renderable.noSemicolon(this.statement.render()));
        }
        return sb.toString();
    }
}

