/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.SundrException;
import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.visitors.TypeRefTypeVisitor;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.ClassRef;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Types;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class AnnotationMirrorToAnnotationRef
implements Function<AnnotationMirror, AnnotationRef> {
    private static final String EMPTY_PARENTHESIS = "()";
    private static final String EMPTY = "";
    private static final String ERROR = "<error>";
    private final AptContext context;
    private final Function<TypeMirror, TypeRef> referenceAdapterFunction;

    public AnnotationMirrorToAnnotationRef(AptContext context, Function<TypeMirror, TypeRef> referenceAdapterFunction) {
        this.context = context;
        this.referenceAdapterFunction = referenceAdapterFunction;
    }

    @Override
    public AnnotationRef apply(AnnotationMirror item) {
        TypeRef annotationType = item.getAnnotationType().accept(new TypeRefTypeVisitor(this.context), 0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (annotationType instanceof ClassRef) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : item.getElementValues().entrySet()) {
                this.checkEntry(entry);
                String key = entry.getKey().toString().replace(EMPTY_PARENTHESIS, EMPTY);
                Object value = this.mapAnnotationValue(entry.getValue().getValue());
                parameters.put(key, value);
            }
            return ((AnnotationRefBuilder)((AnnotationRefBuilder)new AnnotationRefBuilder().withClassRef((ClassRef)annotationType)).withParameters(parameters)).build();
        }
        throw new IllegalStateException("Annotation type: [" + String.valueOf(annotationType) + "] is not a class reference.");
    }

    private Object mapAnnotationValue(Object value) {
        if (value instanceof Collection) {
            List list = ((Collection)value).stream().map(this::mapAnnotationValue).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            return AnnotationMirrorToAnnotationRef.toArray(list);
        }
        if (value instanceof AnnotationMirror) {
            return this.apply((AnnotationMirror)value);
        }
        if (value instanceof AnnotationValue) {
            return ((AnnotationValue)value).getValue();
        }
        if (value instanceof TypeMirror) {
            return this.referenceAdapterFunction.apply((TypeMirror)value);
        }
        return value;
    }

    private void checkEntry(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        TypeRef returnType;
        ExecutableElement key = entry.getKey();
        Object value = entry.getValue().getValue();
        if (ERROR.equals(value) && (returnType = this.referenceAdapterFunction.apply(key.getReturnType())).equals(Types.CLASS)) {
            throw new SundrException("Failed to extract class parameter from annotation. This may be caused due to the compiler not being able to resolve a symbol. Please check for unresolved symbols!");
        }
    }

    private static Object toArray(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        try {
            Class type = AnnotationMirrorToAnnotationRef.toPrimitive(list.get(0).getClass());
            Object result = Array.newInstance(type, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, list.get(i));
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SundrException((Throwable)e);
        }
    }

    private static Class toPrimitive(Class t) {
        String s = t.toString();
        if (s.contains(Boolean.class.getName())) {
            return Boolean.TYPE;
        }
        if (s.contains(Character.class.getName())) {
            return Character.TYPE;
        }
        if (s.contains(Short.class.getName())) {
            return Short.TYPE;
        }
        if (s.contains(Integer.class.getName())) {
            return Integer.TYPE;
        }
        if (s.contains(Long.class.getName())) {
            return Long.TYPE;
        }
        if (s.contains(Double.class.getName())) {
            return Double.TYPE;
        }
        if (s.contains(Float.class.getName())) {
            return Float.TYPE;
        }
        return t;
    }
}

