/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.serialization;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.streamzi.openshift.dataflow.model.ProcessorInputPort;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class SerializedTemplate
implements KubernetesResource {
    private String displayName;
    private String description;
    private String imageName;
    private List<String> inputs;
    private List<String> outputs;
    private Map<String, String> settings;

    public String toString() {
        return "SerializedTemplate{, displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", imageName='" + this.imageName + '\'' + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", settings=" + this.settings + '}';
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public List<String> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<String> outputs) {
        this.outputs = outputs;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public ProcessorNode createProcessorNode() {
        ProcessorNode node = new ProcessorNode();
        node.setImageName(this.imageName);
        node.setSettings(this.settings);
        node.setDisplayName(this.displayName);
        if (this.inputs != null) {
            for (String input : this.inputs) {
                node.addInput(new ProcessorInputPort(input));
            }
        }
        if (this.outputs != null) {
            for (String output : this.outputs) {
                node.addOutput(new ProcessorOutputPort(output));
            }
        }
        return node;
    }
}

