/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.deployment;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.streamzi.openshift.dataflow.FlowUtil;
import io.streamzi.openshift.dataflow.model.ProcessorConstants;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import io.streamzi.openshift.dataflow.model.ProcessorInputPort;
import io.streamzi.openshift.dataflow.model.ProcessorLink;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TargetState {
    private static final Logger logger = Logger.getLogger(TargetState.class.getName());
    private String cloudName;
    private ProcessorFlow flow;
    private Map<String, String> bootstrapServerCache;
    private Set<DeploymentConfig> deploymentConfigs = new HashSet<DeploymentConfig>();
    private Set<ConfigMap> topicConfigMaps = new HashSet<ConfigMap>();
    private Set<ConfigMap> evConfigMaps = new HashSet<ConfigMap>();

    public TargetState(String cloudName, ProcessorFlow flow, Map<String, String> bootstrapServerCache) {
        this.cloudName = cloudName;
        this.flow = flow;
        this.bootstrapServerCache = bootstrapServerCache;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public void setCloudName(String cloudName) {
        this.cloudName = cloudName;
    }

    public Set<DeploymentConfig> getDeploymentConfigs() {
        return this.deploymentConfigs;
    }

    public void setDeploymentConfigs(Set<DeploymentConfig> deploymentConfigs) {
        this.deploymentConfigs = deploymentConfigs;
    }

    public Set<ConfigMap> getTopicConfigMaps() {
        return this.topicConfigMaps;
    }

    public void setTopicConfigMaps(Set<ConfigMap> topicConfigMaps) {
        this.topicConfigMaps = topicConfigMaps;
    }

    public Set<ConfigMap> getEvConfigMaps() {
        return this.evConfigMaps;
    }

    public void setEvConfigMaps(Set<ConfigMap> evConfigMaps) {
        this.evConfigMaps = evConfigMaps;
    }

    public boolean add(DeploymentConfig deploymentConfig) {
        return this.deploymentConfigs.add(deploymentConfig);
    }

    public boolean add(ConfigMap configMap) {
        return this.topicConfigMaps.add(configMap);
    }

    public Set<String> getDeploymentConfigNames() {
        return this.deploymentConfigs.stream().map(dc -> dc.getMetadata().getName()).collect(Collectors.toSet());
    }

    public Set<String> getConfigMapNames() {
        Set topics = this.topicConfigMaps.stream().map(cm -> cm.getMetadata().getName()).collect(Collectors.toSet());
        Set<String> evs = this.evConfigMaps.stream().map(cm -> cm.getMetadata().getName()).collect(Collectors.toSet());
        evs.addAll(topics);
        return evs;
    }

    public void build() {
        this.deploymentConfigs.addAll(this.flow.getNodes().stream().filter(node -> node.getProcessorType().equals((Object)ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE)).filter(node -> node.getTargetClouds().keySet().contains(this.cloudName) && node.getTargetClouds().get(this.cloudName) > 0).map(this::buildDeploymentConfigs).collect(Collectors.toSet()));
        this.evConfigMaps.addAll(this.flow.getNodes().stream().filter(node -> node.getProcessorType().equals((Object)ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE)).filter(node -> node.getTargetClouds().keySet().contains(this.cloudName) && node.getTargetClouds().get(this.cloudName) > 0).map(this::buildEnvVarConfigMaps).collect(Collectors.toSet()));
        this.topicConfigMaps.addAll(this.flow.getLinks().stream().filter(link -> link.getSource().getParent().getProcessorType().equals((Object)ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE)).filter(link -> this.calculateTopicHost(link.getSource().getParent()).equals(this.cloudName)).map(this::buildTopicConfigMaps).collect(Collectors.toSet()));
    }

    private DeploymentConfig buildDeploymentConfigs(ProcessorNode node) {
        String dcName = node.getParent().getName() + "-" + FlowUtil.sanitisePodName(node.getDisplayName()) + "-" + node.getUuid().substring(0, 6);
        Map<String, String> envVarMap = this.getNodeEnvVars(node);
        List envVar = envVarMap.keySet().stream().map(key -> new EnvVar(key, (String)envVarMap.get(key), null)).collect(Collectors.toList());
        Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(node.getParent().getName())).withEnv(envVar)).withImage("docker.io/" + node.getImageName())).withImagePullPolicy("IfNotPresent")).build();
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(dcName)).addToLabels("app", node.getParent().getName())).addToLabels("streamzi/type", "processor-flow")).endMetadata()).withNewSpec().withReplicas(node.getTargetClouds().get(this.cloudName))).addNewTrigger().withType("ConfigChange")).endTrigger()).withNewTemplate().withNewMetadata().addToLabels("app", node.getParent().getName())).endMetadata()).withNewSpec().addNewContainerLike(container).endContainer()).endSpec()).endTemplate()).endSpec()).build();
    }

    private Map<String, String> getNodeEnvVars(ProcessorNode node) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put(FlowUtil.sanitiseEnvVar("STREAMZI_NODE_UUID"), node.getUuid());
        for (String key : node.getSettings().keySet()) {
            envVars.put(FlowUtil.sanitiseEnvVar(key), node.getSettings().get(key));
        }
        for (String key : node.getParent().getGlobalSettings().keySet()) {
            envVars.put(FlowUtil.sanitiseEnvVar(key), node.getParent().getGlobalSettings().get(key));
        }
        for (ProcessorInputPort input : node.getInputs().values()) {
            for (ProcessorLink link : input.getLinks()) {
                ProcessorNode sourceNode = link.getSource().getParent();
                String bootstrapServers = this.bootstrapServerCache.get(this.calculateTopicHost(sourceNode));
                if (sourceNode.getProcessorType() == ProcessorConstants.ProcessorType.TOPIC_ENDPOINT) {
                    envVars.put(FlowUtil.sanitiseEnvVar(input.getName()), link.getSource().getName());
                    continue;
                }
                envVars.put(FlowUtil.sanitiseEnvVar(input.getName() + "_BOOTSTRAP_SERVERS"), bootstrapServers);
                String topicName = node.getParent().getName() + "-" + link.getSource().getParent().getUuid() + "-" + link.getSource().getName();
                envVars.put(FlowUtil.sanitiseEnvVar(input.getName()), topicName);
            }
        }
        for (ProcessorOutputPort output : node.getOutputs().values()) {
            String bootstrapServers = this.bootstrapServerCache.get(this.calculateTopicHost(node));
            envVars.put(FlowUtil.sanitiseEnvVar(output.getName() + "_BOOTSTRAP_SERVERS"), bootstrapServers);
            String topicName = node.getParent().getName() + "-" + node.getUuid() + "-" + output.getName();
            envVars.put(FlowUtil.sanitiseEnvVar(output.getName()), topicName);
        }
        return envVars;
    }

    private ConfigMap buildEnvVarConfigMaps(ProcessorNode node) {
        String dcName = this.flow.getName() + "-" + FlowUtil.sanitisePodName(node.getDisplayName()) + "-" + node.getUuid().substring(0, 6);
        String cmName = dcName + "-ev.cm";
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("streamzi.io/kind", "ev");
        labels.put("streamzi.io/target", dcName);
        labels.put("app", this.flow.getName());
        ObjectMeta om = new ObjectMeta();
        om.setName(cmName);
        om.setLabels(labels);
        ConfigMap cm = new ConfigMap();
        cm.setMetadata(om);
        Map<String, String> evs = this.getNodeEnvVars(node);
        cm.setData(evs);
        return cm;
    }

    private ConfigMap buildTopicConfigMaps(ProcessorLink link) {
        String topicName = this.flow.getName() + "-" + link.getSource().getParent().getUuid() + "-" + link.getSource().getName();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", topicName);
        data.put("partitions", "20");
        data.put("replicas", "1");
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("strimzi.io/cluster", "my-cluster");
        labels.put("strimzi.io/kind", "topic");
        labels.put("streamzi.io/source", "autocreated");
        labels.put("app", this.flow.getName());
        return ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(topicName)).withLabels(labels)).endMetadata()).withData(data)).build();
    }

    private String calculateTopicHost(ProcessorNode node) {
        Optional<String> optCloud = node.getTargetClouds().keySet().stream().max(Comparator.comparingInt(key -> node.getTargetClouds().get(key)));
        return optCloud.orElse("UNKNONW");
    }
}

