/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.deployment;

import io.streamzi.openshift.dataflow.deployment.FlowDeployment;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import java.util.ArrayList;
import java.util.List;

public class FlowDeploymentListBuilder {
    private ProcessorFlow flow;
    private List<String> clouds = new ArrayList<String>();

    public FlowDeploymentListBuilder(ProcessorFlow flow) {
        this.flow = flow;
    }

    public FlowDeploymentListBuilder addCloud(String cloudId) {
        if (!this.clouds.contains(cloudId)) {
            this.clouds.add(cloudId);
        }
        return this;
    }

    public FlowDeploymentListBuilder detectClouds() {
        this.flow.getNodes().stream().forEach(node -> node.getTargetClouds().keySet().stream().forEach(cloudId -> this.addCloud((String)cloudId)));
        return this;
    }

    public List<FlowDeployment> build() {
        ArrayList<FlowDeployment> results = new ArrayList<FlowDeployment>();
        this.clouds.stream().forEach(cloud -> results.add(new FlowDeployment((String)cloud, this.flow)));
        return results;
    }
}

