/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.deployment;

import io.streamzi.openshift.dataflow.deployment.LinkDeployment;
import io.streamzi.openshift.dataflow.deployment.NodeDeployment;
import io.streamzi.openshift.dataflow.model.ProcessorConstants;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import io.streamzi.openshift.dataflow.model.ProcessorLink;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlowDeployment {
    private static final Logger logger = Logger.getLogger(FlowDeployment.class.getName());
    private String cloud;
    private List<NodeDeployment> nodeDeployments = new ArrayList<NodeDeployment>();
    private List<LinkDeployment> linkDeployments = new ArrayList<LinkDeployment>();

    public FlowDeployment(String cloud, ProcessorFlow flow) {
        this.cloud = cloud;
        this.buildFromFlow(flow);
    }

    public final void buildFromFlow(ProcessorFlow flow) {
        flow.getNodes().stream().filter(node -> node.getProcessorType() == ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE).filter(node -> node.getTargetClouds().containsKey(this.cloud)).filter(node -> node.getTargetClouds().get(this.cloud) > 0).forEach(node -> this.nodeDeployments.add(new NodeDeployment((ProcessorNode)node, node.getTargetClouds().get(this.cloud))));
        flow.getLinks().stream().filter(link -> this.containsNode(link.getSource().getParent())).filter(link -> this.containsNode(link.getTarget().getParent())).forEach(link -> this.linkDeployments.add(new LinkDeployment((ProcessorLink)link, LinkDeployment.LinkType.INTERNAL_LINK, this.cloud, this.cloud)));
        flow.getLinks().stream().filter(link -> !this.containsNode(link.getSource().getParent()) || !this.containsNode(link.getTarget().getParent())).forEach(link -> this.addProxiedLink((ProcessorLink)link));
    }

    private void addProxiedLink(ProcessorLink link) {
        int sourceDeploymentsHere = this.getDeploymentsForThisCloud(link.getSource().getParent());
        int targetDeploymentsHere = this.getDeploymentsForThisCloud(link.getTarget().getParent());
        if (sourceDeploymentsHere > 0 && targetDeploymentsHere == 0) {
            this.linkDeployments.add(new LinkDeployment(link, LinkDeployment.LinkType.REMOTE_LINK, this.cloud, this.getFirstNonZeroCloudId(link.getTarget().getParent())));
        } else if (sourceDeploymentsHere == 0 && targetDeploymentsHere > 0) {
            this.linkDeployments.add(new LinkDeployment(link, LinkDeployment.LinkType.REMOTE_LINK, this.getFirstNonZeroCloudId(link.getSource().getParent()), this.cloud));
        } else {
            logger.log(Level.SEVERE, "Invalid deployment for link");
        }
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getFirstNonZeroCloudId(ProcessorNode node) {
        for (String id : node.getTargetClouds().keySet()) {
            if (node.getTargetClouds().get(id) <= 0) continue;
            return id;
        }
        return "UNKNOWN";
    }

    public boolean isDeployedElseWhere(ProcessorNode node) {
        for (String id : node.getTargetClouds().keySet()) {
            if (id.equals(this.cloud) || node.getTargetClouds().get(id) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getDeploymentsForThisCloud(ProcessorNode node) {
        if (node.getTargetClouds().containsKey(this.cloud)) {
            return node.getTargetClouds().get(this.cloud);
        }
        return 0;
    }

    public boolean containsNode(ProcessorNode node) {
        return this.nodeDeployments.stream().filter(d -> d.getNode().equals(node)).count() > 0L;
    }

    public boolean containsLink(LinkDeployment link) {
        for (LinkDeployment d : this.linkDeployments) {
            if (!d.equals(link)) continue;
            return true;
        }
        return false;
    }

    public void print() {
        System.out.println("Cloud: " + this.cloud);
        for (NodeDeployment node : this.nodeDeployments) {
            System.out.println(node);
        }
        for (LinkDeployment link : this.linkDeployments) {
            System.out.println(link);
        }
    }
}

