/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.DocumentationBuilder;
import springfox.documentation.builders.ResourceListingBuilder;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;

@Component
public class ApiDocumentationScanner {
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private ApiListingScanner apiListingScanner;

    @Autowired
    public ApiDocumentationScanner(ApiListingReferenceScanner apiListingReferenceScanner, ApiListingScanner apiListingScanner) {
        this.apiListingReferenceScanner = apiListingReferenceScanner;
        this.apiListingScanner = apiListingScanner;
    }

    public Documentation scan(DocumentationContext context) {
        ApiListingReferenceScanResult result = this.apiListingReferenceScanner.scan(context);
        ApiListingScanningContext listingContext = new ApiListingScanningContext(context, result.getResourceGroupRequestMappings());
        Map<String, List<ApiListing>> apiListings = this.apiListingScanner.scan(listingContext);
        Set tags = Tags.toTags(apiListings);
        tags.addAll(context.getTags());
        DocumentationBuilder group = new DocumentationBuilder().name(context.getGroupName()).apiListingsByResourceGroupName(apiListings).produces(context.getProduces()).consumes(context.getConsumes()).host(context.getHost()).schemes(context.getProtocols()).basePath("/").extensions(context.getVendorExtentions()).tags(tags);
        TreeSet<? extends ApiListingReference> apiReferenceSet = new TreeSet<ApiListingReference>(Orderings.listingReferencePathComparator());
        apiReferenceSet.addAll(this.apiListingReferences(apiListings, context));
        ResourceListing resourceListing = new ResourceListingBuilder().apiVersion(context.getApiInfo().getVersion()).apis(apiReferenceSet.stream().sorted(context.getListingReferenceOrdering()).collect(Collectors.toList())).securitySchemes(context.getSecuritySchemes()).info(context.getApiInfo()).build();
        group.resourceListing(resourceListing);
        return group.build();
    }

    private Collection<? extends ApiListingReference> apiListingReferences(Map<String, List<ApiListing>> apiListings, DocumentationContext context) {
        return apiListings.entrySet().stream().map(this.toApiListingReference(context)).collect(Collectors.toSet());
    }

    private Function<Map.Entry<String, List<ApiListing>>, ApiListingReference> toApiListingReference(DocumentationContext context) {
        return input -> {
            String description = String.join((CharSequence)System.getProperty("line.separator"), this.descriptions((Collection)input.getValue()));
            PathMappingAdjuster adjuster = new PathMappingAdjuster(context);
            PathProvider pathProvider = context.getPathProvider();
            String path = pathProvider.getResourceListingPath(context.getGroupName(), (String)input.getKey());
            return new ApiListingReference(adjuster.adjustedPath(path), description, 0);
        };
    }

    private Iterable<String> descriptions(Collection<ApiListing> apiListings) {
        return apiListings.stream().map(ApiListing::getDescription).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }
}

