/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.util.Collections;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public class SpringGroupingStrategy
implements ResourceGroupingStrategy {
    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.groups(handlerMethod);
    }

    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.getDescription(handlerMethod.getBeanType());
    }

    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return 0;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Set<ResourceGroup> groups(HandlerMethod handlerMethod) {
        Class controllerClazz = handlerMethod.getBeanType();
        String controllerAsGroup = Paths.splitCamelCase(controllerClazz.getSimpleName(), "-").toLowerCase();
        return Collections.singleton(new ResourceGroup(controllerAsGroup, controllerClazz));
    }

    private String getDescription(Class<?> controllerClass) {
        return Paths.splitCamelCase(controllerClass.getSimpleName(), " ");
    }
}

