/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import java.util.Locale;

public class SpringTernaryCheck
extends AbstractSpringCheck {
    private EqualsTest equalsTest = EqualsTest.NEVER_FOR_NULLS;

    public int[] getAcceptableTokens() {
        return new int[]{109};
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 109) {
            this.visitQuestion(ast);
        }
    }

    private void visitQuestion(DetailAST ast) {
        DetailAST expression = ast.getFirstChild();
        if (!this.hasType(expression, 76) && expression != null && this.requiresParens(expression)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "ternary.missingParen", new Object[0]);
        }
        while (this.hasType(expression, 76)) {
            expression = expression.getNextSibling();
        }
        if (this.isSimpleEqualsExpression(expression) && !this.isEqualsTestAllowed(ast)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "ternary.equalOperator", new Object[0]);
        }
    }

    private boolean requiresParens(DetailAST expression) {
        if (expression != null && expression.getChildCount() > 1) {
            switch (expression.getType()) {
                case 27: 
                case 59: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isSimpleEqualsExpression(DetailAST expression) {
        if (expression == null || expression.getType() != 116) {
            return false;
        }
        for (DetailAST child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getChildCount() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualsTestAllowed(DetailAST ast) {
        switch (this.equalsTest) {
            case ANY: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case NEVER_FOR_NULLS: {
                DetailAST equal = ast.findFirstToken(116);
                return equal.findFirstToken(135) == null;
            }
        }
        throw new IllegalStateException("Unsupported equals test " + (Object)((Object)this.equalsTest));
    }

    private boolean hasType(DetailAST ast, int type) {
        return ast != null && ast.getType() == type;
    }

    public void setEqualsTest(String equalsTest) {
        try {
            this.equalsTest = Enum.valueOf(EqualsTest.class, equalsTest.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("unable to parse " + equalsTest, ex);
        }
    }

    public static enum EqualsTest {
        ANY,
        NEVER,
        NEVER_FOR_NULLS;

    }
}

