/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.launch;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.Parameters;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MutableBeanLocator;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.space.BeanScanning;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.space.ClassSpace;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.space.SpaceModule;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.space.URLClassSpace;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.wire.ParameterKeys;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.wire.WireModule;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;

public final class Main
implements Module {
    private final Map<?, ?> properties;
    private final String[] args;

    private Main(Map<?, ?> properties, String ... args) {
        this.properties = Collections.unmodifiableMap(properties);
        this.args = args;
    }

    public static void main(String ... args) {
        Main.boot(System.getProperties(), args);
    }

    public static <T> T boot(Class<T> type, String ... args) {
        return (T)Main.boot(System.getProperties(), args).getInstance(type);
    }

    public static Injector boot(Map<?, ?> properties, String ... args) {
        BeanScanning scanning = BeanScanning.select(properties);
        Module app = Main.wire(scanning, new Main(properties, args));
        Injector injector = Guice.createInjector((Module[])new Module[]{app});
        return injector;
    }

    public static Module wire(BeanScanning scanning, Module ... bindings) {
        Module[] modules = new Module[bindings.length + 1];
        System.arraycopy(bindings, 0, modules, 0, bindings.length);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        modules[bindings.length] = new SpaceModule((ClassSpace)new URLClassSpace(tccl), scanning);
        return new WireModule(modules);
    }

    public void configure(Binder binder) {
        binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
        binder.bind(ShutdownThread.class).asEagerSingleton();
    }

    @Provides
    @Parameters
    String[] parameters() {
        return (String[])this.args.clone();
    }

    static final class ShutdownThread
    extends Thread {
        private final MutableBeanLocator locator;

        @Inject
        ShutdownThread(MutableBeanLocator locator) {
            this.locator = locator;
            Runtime.getRuntime().addShutdownHook(this);
        }

        @Override
        public void run() {
            this.locator.clear();
        }
    }
}

