/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.Exclusion;
import io.spring.gradle.dependencymanagement.internal.maven.EffectiveModelBuilder;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.CompositePropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.MapPropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Dependency;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.specs.Specs;

public class MavenPomResolver
implements PomResolver {
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final EffectiveModelBuilder effectiveModelBuilder;
    private final DependencyHandler dependencyHandler;

    public MavenPomResolver(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
        this.effectiveModelBuilder = new EffectiveModelBuilder(project, configurationContainer);
        this.dependencyHandler = project.getDependencies();
    }

    @Override
    public List<Pom> resolvePomsLeniently(List<PomReference> pomReferences) {
        return this.createPoms(this.createConfiguration(pomReferences).getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL), pomReferences, new MapPropertySource(Collections.emptyMap()));
    }

    @Override
    public List<Pom> resolvePoms(List<PomReference> pomReferences, PropertySource properties) {
        List<PomReference> deduplicatedPomReferences = this.deduplicate(pomReferences);
        Configuration configuration = this.createConfiguration(deduplicatedPomReferences);
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        return this.createPoms(resolvedConfiguration.getResolvedArtifacts(), deduplicatedPomReferences, properties);
    }

    private List<PomReference> deduplicate(List<PomReference> pomReferences) {
        ArrayList<PomReference> deduplicatedReferences = new ArrayList<PomReference>();
        HashSet<String> seen = new HashSet<String>();
        for (int i = pomReferences.size() - 1; i >= 0; --i) {
            PomReference pomReference = pomReferences.get(i);
            if (!seen.add(pomReference.getCoordinates().getGroupAndArtifactId())) continue;
            deduplicatedReferences.add(pomReference);
        }
        Collections.reverse(deduplicatedReferences);
        return deduplicatedReferences;
    }

    private Configuration createConfiguration(List<PomReference> pomReferences) {
        Configuration configuration = this.configurationContainer.newConfiguration(new org.gradle.api.artifacts.Dependency[0]);
        for (PomReference pomReference : pomReferences) {
            Coordinates coordinates = pomReference.getCoordinates();
            org.gradle.api.artifacts.Dependency dependency = this.dependencyHandler.create((Object)(coordinates.getGroupId() + ":" + coordinates.getArtifactId() + ":" + coordinates.getVersion() + "@pom"));
            configuration.getDependencies().add((Object)dependency);
        }
        return configuration;
    }

    private List<Pom> createPoms(Set<ResolvedArtifact> resolvedArtifacts, List<PomReference> pomReferences, PropertySource properties) {
        HashMap<String, PomReference> referencesById = new HashMap<String, PomReference>();
        for (PomReference pomReference : pomReferences) {
            referencesById.put(pomReference.getCoordinates().getGroupAndArtifactId(), pomReference);
        }
        ArrayList<EffectiveModelBuilder.ModelInput> modelInputs = new ArrayList<EffectiveModelBuilder.ModelInput>();
        for (ResolvedArtifact resolvedArtifact : resolvedArtifacts) {
            ModuleVersionIdentifier id = resolvedArtifact.getModuleVersion().getId();
            PomReference reference = (PomReference)referencesById.get(id.getGroup() + ":" + id.getName());
            CompositePropertySource allProperties = new CompositePropertySource(reference.getProperties(), properties);
            modelInputs.add(new EffectiveModelBuilder.ModelInput(resolvedArtifact.getFile(), allProperties));
        }
        return this.createPoms(modelInputs);
    }

    private List<Pom> createPoms(List<EffectiveModelBuilder.ModelInput> inputs) {
        List<Model> effectiveModels = this.effectiveModelBuilder.buildModels(inputs);
        ArrayList<Pom> poms = new ArrayList<Pom>(effectiveModels.size());
        for (Model effectiveModel : effectiveModels) {
            Coordinates coordinates = new Coordinates(effectiveModel.getGroupId(), effectiveModel.getArtifactId(), effectiveModel.getVersion());
            List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> managedDependencies = this.getManagedDependencies(effectiveModel);
            List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> dependencies = this.getDependencies(effectiveModel);
            Map<String, String> properties = this.asMap(effectiveModel.getProperties());
            poms.add(new Pom(coordinates, managedDependencies, dependencies, properties));
        }
        return poms;
    }

    private List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> getManagedDependencies(Model model) {
        if (model.getDependencyManagement() == null || model.getDependencyManagement().getDependencies() == null) {
            return Collections.emptyList();
        }
        return model.getDependencyManagement().getDependencies().stream().map(this::createDependency).collect(Collectors.toList());
    }

    private io.spring.gradle.dependencymanagement.internal.pom.Dependency createDependency(Dependency dependency) {
        LinkedHashSet<Exclusion> exclusions = new LinkedHashSet<Exclusion>();
        if (dependency.getExclusions() != null) {
            dependency.getExclusions().stream().map(exclusion -> new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId())).forEach(exclusions::add);
        }
        Coordinates coordinates = new Coordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        return new io.spring.gradle.dependencymanagement.internal.pom.Dependency(coordinates, dependency.isOptional(), dependency.getType(), dependency.getClassifier(), dependency.getScope(), exclusions);
    }

    private List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> getDependencies(Model model) {
        if (model.getDependencies() == null) {
            return Collections.emptyList();
        }
        return model.getDependencies().stream().map(this::createDependency).collect(Collectors.toList());
    }

    private Map<String, String> asMap(Properties properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }
}

