/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import io.spring.gradle.dependencymanagement.dsl.DependencyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.InvalidUserDataException;

final class StandardDependencyHandler
implements DependencyHandler {
    private final List<String> exclusions = new ArrayList<String>();

    StandardDependencyHandler() {
    }

    @Override
    public void exclude(String exclusion) {
        String[] components = exclusion.split(":");
        if (components.length != 2) {
            throw new InvalidUserDataException("Exclusion '" + exclusion + "' is malformed. The required form is 'group:name'");
        }
        this.exclusions.add(exclusion);
    }

    @Override
    public void exclude(Map<String, String> exclusion) {
        String group = exclusion.get("group");
        String name = exclusion.get("name");
        if (!this.hasText(group) || !this.hasText(name)) {
            throw new InvalidUserDataException("An exclusion requires both a group and a name");
        }
        this.exclusions.add(exclusion.get("group") + ":" + exclusion.get("name"));
    }

    List<String> getExclusions() {
        return this.exclusions;
    }

    private boolean hasText(String string) {
        return string != null && string.trim().length() > 0;
    }
}

