/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.dsl.HoverflyDsl;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;

public class ResponseCreators {
    private static final int CREATED = 201;
    private static final int OK = 200;
    private static final int NO_CONTENT = 204;
    private static final int BAD_REQUEST = 400;
    private static final int SERVER_ERROR = 500;
    private static final int FORBIDDEN = 403;
    private static final int UNAUTHORISED = 401;
    private static final int NOT_FOUND = 404;

    private ResponseCreators() {
    }

    public static ResponseBuilder created(String locationHeaderValue) {
        return HoverflyDsl.response().status(201).header("Location", locationHeaderValue);
    }

    public static ResponseBuilder created() {
        return HoverflyDsl.response().status(201);
    }

    public static ResponseBuilder success(String body, String contentType) {
        return HoverflyDsl.response().status(200).body(body).header("Content-Type", contentType);
    }

    public static ResponseBuilder success() {
        return HoverflyDsl.response().status(200);
    }

    public static ResponseBuilder noContent() {
        return HoverflyDsl.response().status(204);
    }

    public static ResponseBuilder badRequest() {
        return HoverflyDsl.response().status(400);
    }

    public static ResponseBuilder serverError() {
        return HoverflyDsl.response().status(500);
    }

    public static ResponseBuilder forbidden() {
        return HoverflyDsl.response().status(403);
    }

    public static ResponseBuilder unauthorised() {
        return HoverflyDsl.response().status(401);
    }

    public static ResponseBuilder notFound() {
        return HoverflyDsl.response().status(404);
    }

    public static ResponseBuilder success(HttpBodyConverter httpBodyConverter) {
        return HoverflyDsl.response().status(200).body(httpBodyConverter);
    }
}

