/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.GlobalActions;
import io.specto.hoverfly.junit.core.model.HoverflyData;
import io.specto.hoverfly.junit.core.model.HoverflyMetaData;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface SimulationSource {
    public static SimulationSource url(URL url) {
        return () -> {
            try (InputStream is = url.openStream();){
                String string = HoverflyUtils.convertStreamToString(is);
                return string;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource url(String url) {
        return () -> {
            try (InputStream is = new URL(url).openStream();){
                String string = HoverflyUtils.convertStreamToString(is);
                return string;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource classpath(String classpath) {
        return () -> {
            try (InputStream is = HoverflyUtils.getClasspathResourceAsStream(classpath);){
                String string = HoverflyUtils.convertStreamToString(is);
                return string;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot load classpath resource: '" + classpath + "'", e);
            }
        };
    }

    public static SimulationSource defaultPath(String pathString) {
        return () -> {
            String fullClasspath = "hoverfly/" + pathString;
            try (InputStream is = HoverflyUtils.getClasspathResourceAsStream(fullClasspath);){
                String string = HoverflyUtils.convertStreamToString(is);
                return string;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot load default path resource: '" + pathString + "'", e);
            }
        };
    }

    public static SimulationSource file(Path path) {
        return () -> {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                String string = HoverflyUtils.convertStreamToString(is);
                return string;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot load file resource: '" + path.toString() + "'", e);
            }
        };
    }

    public static SimulationSource dsl(StubServiceBuilder ... stubServiceBuilder) {
        return () -> {
            Set pairs = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getRequestResponsePairs).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            List<DelaySettings> delaySettings = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getDelaySettings).flatMap(Collection::stream).collect(Collectors.toList());
            return HoverflyUtils.writeSimulationAsString(new Simulation(new HoverflyData(pairs, new GlobalActions(delaySettings)), new HoverflyMetaData()));
        };
    }

    public static SimulationSource simulation(Simulation simulation) {
        return () -> HoverflyUtils.writeSimulationAsString(simulation);
    }

    public static SimulationSource empty() {
        return () -> HoverflyUtils.writeSimulationAsString(Simulation.newEmptyInstance());
    }

    public String getSimulation();
}

