/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.exhibitor.standalone;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.exhibitor.core.ExhibitorArguments;
import com.netflix.exhibitor.core.backup.BackupProvider;
import com.netflix.exhibitor.core.backup.filesystem.FileSystemBackupProvider;
import com.netflix.exhibitor.core.backup.s3.S3BackupProvider;
import com.netflix.exhibitor.core.config.AutoManageLockArguments;
import com.netflix.exhibitor.core.config.ConfigProvider;
import com.netflix.exhibitor.core.config.DefaultProperties;
import com.netflix.exhibitor.core.config.IntConfigs;
import com.netflix.exhibitor.core.config.JQueryStyle;
import com.netflix.exhibitor.core.config.PropertyBasedInstanceConfig;
import com.netflix.exhibitor.core.config.StringConfigs;
import com.netflix.exhibitor.core.config.consul.ConsulConfigProvider;
import com.netflix.exhibitor.core.config.filesystem.FileSystemConfigProvider;
import com.netflix.exhibitor.core.config.none.NoneConfigProvider;
import com.netflix.exhibitor.core.config.s3.S3ConfigArguments;
import com.netflix.exhibitor.core.config.s3.S3ConfigAutoManageLockArguments;
import com.netflix.exhibitor.core.config.s3.S3ConfigProvider;
import com.netflix.exhibitor.core.config.zookeeper.ZookeeperConfigProvider;
import com.netflix.exhibitor.core.s3.PropertyBasedS3ClientConfig;
import com.netflix.exhibitor.core.s3.PropertyBasedS3Credential;
import com.netflix.exhibitor.core.s3.S3ClientConfig;
import com.netflix.exhibitor.core.s3.S3ClientFactory;
import com.netflix.exhibitor.core.s3.S3ClientFactoryImpl;
import com.netflix.exhibitor.core.s3.S3Credential;
import com.netflix.exhibitor.core.servo.ServoRegistration;
import com.netflix.exhibitor.standalone.ExhibitorCLI;
import com.netflix.exhibitor.standalone.ExhibitorCreatorExit;
import com.netflix.exhibitor.standalone.MissingConfigurationTypeException;
import com.netflix.exhibitor.standalone.NullHostnameVerifier;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.jmx.JmxMonitorRegistry;
import com.orbitz.consul.Consul;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.Credential;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorCreator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExhibitorArguments.Builder builder;
    private final SecurityHandler securityHandler;
    private final BackupProvider backupProvider;
    private final ConfigProvider configProvider;
    private final int httpPort;
    private final String listenAddress;
    private final List<Closeable> closeables = Lists.newArrayList();
    private final String securityFile;
    private final String realmSpec;
    private final String remoteAuthSpec;

    public ExhibitorCreator(String[] args) throws Exception {
        JQueryStyle jQueryStyle;
        String configType;
        CommandLine commandLine;
        ExhibitorCLI cli = new ExhibitorCLI();
        try {
            PosixParser parser = new PosixParser();
            commandLine = parser.parse(cli.getOptions(), args);
            if (commandLine.hasOption('?') || commandLine.hasOption("help") || commandLine.getArgList().size() > 0) {
                throw new ExhibitorCreatorExit(cli);
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new ExhibitorCreatorExit("Unknown option: " + e.getOption(), cli);
        }
        catch (ParseException e) {
            throw new ExhibitorCreatorExit(cli);
        }
        this.checkMutuallyExclusive(cli, commandLine, "s3backup", "filesystembackup");
        String s3Region = commandLine.getOptionValue("s3region", null);
        PropertyBasedS3Credential awsCredentials = null;
        PropertyBasedS3ClientConfig awsClientConfig = null;
        if (commandLine.hasOption("s3credentials")) {
            awsCredentials = new PropertyBasedS3Credential(new File(commandLine.getOptionValue("s3credentials")));
        }
        if (commandLine.hasOption("s3proxy")) {
            awsClientConfig = new PropertyBasedS3ClientConfig(new File(commandLine.getOptionValue("s3proxy")));
        }
        S3BackupProvider backupProvider = null;
        if ("true".equalsIgnoreCase(commandLine.getOptionValue("s3backup"))) {
            backupProvider = new S3BackupProvider((S3ClientFactory)new S3ClientFactoryImpl(), (S3Credential)awsCredentials, (S3ClientConfig)awsClientConfig, s3Region);
        } else if ("true".equalsIgnoreCase(commandLine.getOptionValue("filesystembackup"))) {
            backupProvider = new FileSystemBackupProvider();
        }
        int timeoutMs = Integer.parseInt(commandLine.getOptionValue("timeout", "30000"));
        int logWindowSizeLines = Integer.parseInt(commandLine.getOptionValue("loglines", "1000"));
        int configCheckMs = Integer.parseInt(commandLine.getOptionValue("configcheckms", "30000"));
        String useHostname = commandLine.getOptionValue("hostname", cli.getHostname());
        int httpPort = Integer.parseInt(commandLine.getOptionValue("port", "8080"));
        String listenAddress = commandLine.getOptionValue("listenaddress", "0.0.0.0");
        String extraHeadingText = commandLine.getOptionValue("headingtext", null);
        boolean allowNodeMutations = "true".equalsIgnoreCase(commandLine.getOptionValue("nodemodification", "true"));
        String string = commandLine.hasOption("c") ? commandLine.getOptionValue("c") : (configType = commandLine.hasOption("configtype") ? commandLine.getOptionValue("configtype") : null);
        if (configType == null) {
            throw new MissingConfigurationTypeException("Configuration type (-c or --configtype) must be specified", cli);
        }
        ConfigProvider configProvider = this.makeConfigProvider(configType, cli, commandLine, awsCredentials, awsClientConfig, (BackupProvider)backupProvider, useHostname, s3Region);
        if (configProvider == null) {
            throw new ExhibitorCreatorExit(cli);
        }
        boolean isNoneConfigProvider = configProvider instanceof NoneConfigProvider;
        if (isNoneConfigProvider) {
            backupProvider = null;
        }
        try {
            jQueryStyle = JQueryStyle.valueOf((String)commandLine.getOptionValue("jquerystyle", "red").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ExhibitorCreatorExit(cli);
        }
        this.securityFile = commandLine.getOptionValue("security");
        this.realmSpec = commandLine.getOptionValue("realm");
        this.remoteAuthSpec = commandLine.getOptionValue("remoteauth");
        String realm = commandLine.getOptionValue("basicauthrealm");
        String user = commandLine.getOptionValue("consoleuser");
        String password = commandLine.getOptionValue("consolepassword");
        String curatorUser = commandLine.getOptionValue("curatoruser");
        String curatorPassword = commandLine.getOptionValue("curatorpassword");
        SecurityHandler handler = null;
        if (this.notNullOrEmpty(realm) && this.notNullOrEmpty(user) && this.notNullOrEmpty(password) && this.notNullOrEmpty(curatorUser) && this.notNullOrEmpty(curatorPassword)) {
            this.log.warn(Joiner.on((String)", ").join((Object)"basicauthrealm", (Object)"consoleuser", new Object[]{"consolepassword", "curatoruser", "curatorpassword"}) + " - have been deprecated. Use TBD instead");
            handler = this.makeSecurityHandler(realm, user, password, curatorUser, curatorPassword);
        }
        String aclId = commandLine.getOptionValue("aclid");
        String aclScheme = commandLine.getOptionValue("aclscheme");
        String aclPerms = commandLine.getOptionValue("aclperms");
        ACLProvider aclProvider = null;
        if ((this.notNullOrEmpty(aclId) || this.notNullOrEmpty(aclScheme) || this.notNullOrEmpty(aclPerms)) && (aclProvider = this.getAclProvider(cli, aclId, aclScheme, aclPerms)) == null) {
            throw new ExhibitorCreatorExit(cli);
        }
        ServoRegistration servoRegistration = null;
        if ("true".equalsIgnoreCase(commandLine.getOptionValue("servo", "false"))) {
            servoRegistration = new ServoRegistration((MonitorRegistry)new JmxMonitorRegistry("exhibitor"), 60000);
        }
        String preferencesPath = commandLine.getOptionValue("prefspath");
        this.builder = ExhibitorArguments.builder().connectionTimeOutMs(timeoutMs).logWindowSizeLines(logWindowSizeLines).thisJVMHostname(useHostname).configCheckMs(configCheckMs).extraHeadingText(extraHeadingText).allowNodeMutations(allowNodeMutations).jQueryStyle(jQueryStyle).restPort(httpPort).aclProvider(aclProvider).servoRegistration(servoRegistration).preferencesPath(preferencesPath);
        this.securityHandler = handler;
        this.backupProvider = backupProvider;
        this.configProvider = configProvider;
        this.httpPort = httpPort;
        this.listenAddress = listenAddress;
    }

    public ExhibitorArguments.Builder getBuilder() {
        return this.builder;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public BackupProvider getBackupProvider() {
        return this.backupProvider;
    }

    public List<Closeable> getCloseables() {
        return this.closeables;
    }

    public String getSecurityFile() {
        return this.securityFile;
    }

    public String getRealmSpec() {
        return this.realmSpec;
    }

    public String getRemoteAuthSpec() {
        return this.remoteAuthSpec;
    }

    private ConfigProvider makeConfigProvider(String configType, ExhibitorCLI cli, CommandLine commandLine, PropertyBasedS3Credential awsCredentials, PropertyBasedS3ClientConfig awsClientConfig, BackupProvider backupProvider, String useHostname, String s3Region) throws Exception {
        ConfigProvider configProvider;
        Properties defaultProperties = this.makeDefaultProperties(commandLine, backupProvider);
        if (configType.equals("s3")) {
            configProvider = this.getS3Provider(cli, commandLine, awsCredentials, awsClientConfig, useHostname, defaultProperties, s3Region);
        } else if (configType.equals("file")) {
            configProvider = this.getFileSystemProvider(commandLine, defaultProperties);
        } else if (configType.equals("zookeeper")) {
            configProvider = this.getZookeeperProvider(commandLine, useHostname, defaultProperties);
        } else if (configType.equals("consul")) {
            configProvider = this.getConsulProvider(cli, commandLine, defaultProperties);
        } else if (configType.equals("none")) {
            this.log.warn("Warning: you have intentionally turned off shared configuration. This mode is meant for special purposes only. Please verify that this is your intent.");
            configProvider = this.getNoneProvider(commandLine, defaultProperties);
        } else {
            configProvider = null;
            this.log.error("Unknown configtype: " + configType);
        }
        return configProvider;
    }

    private Properties makeDefaultProperties(CommandLine commandLine, BackupProvider backupProvider) throws IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)DefaultProperties.get((BackupProvider)backupProvider));
        this.addInitialConfigFile(commandLine, properties);
        return new PropertyBasedInstanceConfig(properties, new Properties()).getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInitialConfigFile(CommandLine commandLine, Properties properties) throws IOException {
        Properties defaultProperties = new Properties();
        String defaultConfigFile = commandLine.getOptionValue("defaultconfig");
        if (defaultConfigFile == null) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(defaultConfigFile));
        try {
            defaultProperties.load(in);
        }
        finally {
            CloseableUtils.closeQuietly((Closeable)in);
        }
        HashSet propertyNames = Sets.newHashSet();
        for (StringConfigs stringConfigs : StringConfigs.values()) {
            propertyNames.add(PropertyBasedInstanceConfig.toName((Enum)stringConfigs, (String)""));
        }
        for (StringConfigs stringConfigs : IntConfigs.values()) {
            propertyNames.add(PropertyBasedInstanceConfig.toName((Enum)stringConfigs, (String)""));
        }
        for (String name : defaultProperties.stringPropertyNames()) {
            if (propertyNames.contains(name)) {
                String value = defaultProperties.getProperty(name);
                properties.setProperty("com.netflix.exhibitor." + name, value);
                continue;
            }
            this.log.warn("Ignoring unknown config: " + name);
        }
    }

    private ConfigProvider getNoneProvider(CommandLine commandLine, Properties defaultProperties) {
        if (!commandLine.hasOption("noneconfigdir")) {
            this.log.error("noneconfigdir is required when configtype is \"none\"");
            return null;
        }
        return new NoneConfigProvider(commandLine.getOptionValue("noneconfigdir"), defaultProperties);
    }

    private ConfigProvider getZookeeperProvider(CommandLine commandLine, String useHostname, Properties defaultProperties) throws Exception {
        int pollingMs;
        int exhibitorPort;
        int maxRetries;
        int baseSleepTimeMs;
        String connectString = commandLine.getOptionValue("zkconfigconnect");
        String path = commandLine.getOptionValue("zkconfigzpath");
        String retrySpec = commandLine.getOptionValue("zkconfigretry", "1000:3");
        if (path == null || connectString == null) {
            this.log.error("Both zkconfigconnect and zkconfigzpath are required when the configtype is zookeeper");
            return null;
        }
        try {
            PathUtils.validatePath((String)path);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Invalid zkconfigzpath: " + path);
            return null;
        }
        String[] retryParts = retrySpec.split("\\:");
        if (retryParts.length != 2) {
            this.log.error("Bad zkconfigretry value: " + retrySpec);
            return null;
        }
        try {
            baseSleepTimeMs = Integer.parseInt(retryParts[0]);
            maxRetries = Integer.parseInt(retryParts[1]);
        }
        catch (NumberFormatException e) {
            this.log.error("Bad zkconfigretry value: " + retrySpec);
            return null;
        }
        try {
            exhibitorPort = commandLine.hasOption("zkconfigexhibitorport") ? Integer.parseInt(commandLine.getOptionValue("zkconfigexhibitorport")) : 0;
        }
        catch (NumberFormatException e) {
            this.log.error("Bad zkconfigexhibitorport value: " + commandLine.getOptionValue("zkconfigexhibitorport"));
            return null;
        }
        try {
            pollingMs = Integer.parseInt(commandLine.getOptionValue("zkconfigpollms", "10000"));
        }
        catch (NumberFormatException e) {
            this.log.error("Bad zkconfigpollms value: " + commandLine.getOptionValue("zkconfigpollms", "10000"));
            return null;
        }
        String exhibitorRestPath = commandLine.getOptionValue("zkconfigexhibitorpath", "/");
        CuratorFramework client = this.makeCurator(connectString, baseSleepTimeMs, maxRetries, exhibitorPort, exhibitorRestPath, pollingMs);
        if (client == null) {
            return null;
        }
        client.start();
        this.closeables.add((Closeable)client);
        return new ZookeeperConfigProvider(client, path, defaultProperties, useHostname);
    }

    private ACLProvider getAclProvider(ExhibitorCLI cli, String aclId, String aclScheme, String aclPerms) throws ExhibitorCreatorExit {
        int perms;
        if (this.notNullOrEmpty(aclPerms)) {
            perms = 0;
            for (String verb : aclPerms.split(",")) {
                if ((verb = verb.trim()).equalsIgnoreCase("read")) {
                    perms |= 1;
                    continue;
                }
                if (verb.equalsIgnoreCase("write")) {
                    perms |= 2;
                    continue;
                }
                if (verb.equalsIgnoreCase("create")) {
                    perms |= 4;
                    continue;
                }
                if (verb.equalsIgnoreCase("delete")) {
                    perms |= 8;
                    continue;
                }
                if (verb.equalsIgnoreCase("admin")) {
                    perms |= 0x10;
                    continue;
                }
                this.log.error("Unknown ACL perm value: " + verb);
                throw new ExhibitorCreatorExit(cli);
            }
        } else {
            perms = 31;
        }
        if (aclId == null) {
            aclId = "";
        }
        if (aclScheme == null) {
            aclScheme = "";
        }
        final ACL acl = new ACL(perms, new Id(aclScheme, aclId));
        return new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                return Collections.singletonList(acl);
            }

            public List<ACL> getAclForPath(String path) {
                return Collections.singletonList(acl);
            }
        };
    }

    private ConfigProvider getFileSystemProvider(CommandLine commandLine, Properties defaultProperties) throws IOException {
        File directory = commandLine.hasOption("fsconfigdir") ? new File(commandLine.getOptionValue("fsconfigdir")) : new File(System.getProperty("user.dir"));
        String name = commandLine.hasOption("fsconfigname") ? commandLine.getOptionValue("fsconfigname") : "exhibitor.properties";
        String lockPrefix = commandLine.hasOption("fsconfiglockprefix") ? commandLine.getOptionValue("fsconfiglockprefix") : "exhibitor-lock-";
        return new FileSystemConfigProvider(directory, name, defaultProperties, new AutoManageLockArguments(lockPrefix));
    }

    private ConfigProvider getS3Provider(ExhibitorCLI cli, CommandLine commandLine, PropertyBasedS3Credential awsCredentials, PropertyBasedS3ClientConfig awsClientConfig, String hostname, Properties defaultProperties, String s3Region) throws Exception {
        String prefix = cli.getOptions().hasOption("s3configprefix") ? commandLine.getOptionValue("s3configprefix") : "exhibitor-";
        return new S3ConfigProvider((S3ClientFactory)new S3ClientFactoryImpl(), (S3Credential)awsCredentials, (S3ClientConfig)awsClientConfig, this.getS3Arguments(cli, commandLine.getOptionValue("s3config"), prefix), hostname, defaultProperties, s3Region);
    }

    private ConfigProvider getConsulProvider(ExhibitorCLI cli, CommandLine commandLine, Properties defaultProperties) throws Exception {
        String host = commandLine.getOptionValue("consulhost", "localhost");
        Integer port = Integer.valueOf(commandLine.getOptionValue("consulport", "8500"));
        String prefix = commandLine.getOptionValue("consulprefix", "exhibitor/");
        Boolean sslEnabled = Boolean.valueOf(commandLine.getOptionValue("consulssl", "false"));
        String protocol = sslEnabled != false ? "https" : "http";
        String url = String.format("%s://%s:%d", protocol, host, port);
        Consul.Builder builder = Consul.builder().withUrl(url);
        if (sslEnabled.booleanValue()) {
            if (!Boolean.valueOf(commandLine.getOptionValue("consulsslverifyhostname", "true")).booleanValue()) {
                builder.withHostnameVerifier((HostnameVerifier)new NullHostnameVerifier());
            }
            String sslProtocol = commandLine.getOptionValue("consulsslprotocol", "TLSv1.2");
            String caCertPath = commandLine.getOptionValue("consulsslcacert");
            this.log.debug("SSL enabled for consul connections; protocol = %s, cacert = %s", (Object)sslProtocol, (Object)caCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cacert = (X509Certificate)cf.generateCertificate(new FileInputStream(caCertPath));
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            trustStore.setCertificateEntry("caCert", cacert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(sslProtocol);
            sslContext.init(null, tmf.getTrustManagers(), null);
            builder.withSslContext(sslContext);
        } else {
            this.log.debug("SSL is disabled for consul connections");
        }
        if (commandLine.hasOption("consulacltoken")) {
            builder.withAclToken(commandLine.getOptionValue("consulacltoken"));
        }
        Consul consul = builder.build();
        return new ConsulConfigProvider(consul, prefix, defaultProperties);
    }

    private void checkMutuallyExclusive(ExhibitorCLI cli, CommandLine commandLine, String option1, String option2) throws ExhibitorCreatorExit {
        if (commandLine.hasOption(option1) && commandLine.hasOption(option2)) {
            this.log.error(option1 + " and " + option2 + " cannot be used at the same time");
            throw new ExhibitorCreatorExit(cli);
        }
    }

    private S3ConfigArguments getS3Arguments(ExhibitorCLI cli, String value, String prefix) throws ExhibitorCreatorExit {
        String[] parts = value.split(":");
        if (parts.length != 2) {
            this.log.error("Bad s3config argument: " + value);
            throw new ExhibitorCreatorExit(cli);
        }
        return new S3ConfigArguments(parts[0].trim(), parts[1].trim(), new S3ConfigAutoManageLockArguments(prefix + "-lock-"));
    }

    private CuratorFramework makeCurator(final String connectString, int baseSleepTimeMs, int maxRetries, int exhibitorPort, String exhibitorRestPath, int pollingMs) {
        String[] parts;
        ArrayList hostnames = Lists.newArrayList();
        for (String spec : parts = connectString.split(",")) {
            String[] subParts = spec.split(":");
            try {
                if (subParts.length != 2) {
                    this.log.error("Bad connection string: " + connectString);
                    return null;
                }
            }
            catch (NumberFormatException e) {
                this.log.error("Bad connection string: " + connectString);
                return null;
            }
            hostnames.add(subParts[0]);
        }
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries);
        Exhibitors.BackupConnectionStringProvider backupConnectionStringProvider = new Exhibitors.BackupConnectionStringProvider(){

            public String getBackupConnectionString() throws Exception {
                return connectString;
            }
        };
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)retryPolicy);
        if (exhibitorPort > 0) {
            Exhibitors exhibitors = new Exhibitors((Collection)hostnames, exhibitorPort, backupConnectionStringProvider);
            ExhibitorEnsembleProvider ensembleProvider = new ExhibitorEnsembleProvider(exhibitors, (ExhibitorRestClient)new DefaultExhibitorRestClient(), exhibitorRestPath + "exhibitor/v1/cluster/list", pollingMs, (RetryPolicy)retryPolicy);
            builder = builder.ensembleProvider((EnsembleProvider)ensembleProvider);
        } else {
            this.log.warn("Exhibitor on the shared ZooKeeper config ensemble is not being used.");
        }
        return builder.build();
    }

    private boolean notNullOrEmpty(String arg) {
        return arg != null && !"".equals(arg);
    }

    private SecurityHandler makeSecurityHandler(String realm, String consoleUser, String consolePassword, String curatorUser, String curatorPassword) {
        HashUserRealm userRealm = new HashUserRealm(realm);
        userRealm.put((Object)consoleUser, (Object)Credential.getCredential((String)consolePassword));
        userRealm.addUserToRole(consoleUser, "console");
        userRealm.put((Object)curatorUser, (Object)Credential.getCredential((String)curatorPassword));
        userRealm.addUserToRole(curatorUser, "curator");
        Constraint console = new Constraint();
        console.setName("consoleauth");
        console.setRoles(new String[]{"console"});
        console.setAuthenticate(true);
        Constraint curator = new Constraint();
        curator.setName("curatorauth");
        curator.setRoles(new String[]{"curator", "console"});
        curator.setAuthenticate(true);
        ConstraintMapping consoleMapping = new ConstraintMapping();
        consoleMapping.setConstraint(console);
        consoleMapping.setPathSpec("/*");
        ConstraintMapping curatorMapping = new ConstraintMapping();
        curatorMapping.setConstraint(curator);
        curatorMapping.setPathSpec("/exhibitor/v1/cluster/list");
        SecurityHandler handler = new SecurityHandler();
        handler.setUserRealm((UserRealm)userRealm);
        handler.setConstraintMappings(new ConstraintMapping[]{consoleMapping, curatorMapping});
        handler.setAuthenticator((Authenticator)new BasicAuthenticator());
        return handler;
    }
}

