/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.exhibitor.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.netflix.exhibitor.core.Exhibitor;
import com.netflix.exhibitor.standalone.ExhibitorCreator;
import com.netflix.exhibitor.standalone.ExhibitorCreatorExit;
import com.netflix.exhibitor.standalone.MissingConfigurationTypeException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.curator.utils.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorServletContextListener
implements ServletContextListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile Exhibitor exhibitor;
    private volatile ExhibitorCreator exhibitorCreator;
    private static final String OUR_PREFIX = "exhibitor-";
    private static final String EXHIBITOR_PROPERTIES = "exhibitor.properties";

    public void contextInitialized(ServletContextEvent event) {
        Map<String, String> argsBuilder = this.makeArgsBuilder();
        try {
            this.exhibitorCreator = new ExhibitorCreator(this.toArgsArray(argsBuilder));
            this.exhibitor = new Exhibitor(this.exhibitorCreator.getConfigProvider(), null, this.exhibitorCreator.getBackupProvider(), this.exhibitorCreator.getBuilder().build());
            this.exhibitor.start();
            event.getServletContext().setAttribute(ExhibitorServletContextListener.class.getName(), (Object)this.exhibitor);
        }
        catch (MissingConfigurationTypeException exit) {
            this.log.error("Configuration type (exhibitor-configtype) must be specified");
            exit.getCli().logHelp(OUR_PREFIX);
            throw new RuntimeException(exit);
        }
        catch (ExhibitorCreatorExit exit) {
            if (exit.getError() != null) {
                this.log.error(exit.getError());
            }
            exit.getCli().logHelp(OUR_PREFIX);
            throw new RuntimeException(exit);
        }
        catch (Exception e) {
            this.log.error("Trying to create Exhibitor", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.exhibitor != null) {
            CloseableUtils.closeQuietly((Closeable)this.exhibitor);
            this.exhibitor = null;
        }
        if (this.exhibitorCreator != null) {
            for (Closeable closeable : this.exhibitorCreator.getCloseables()) {
                CloseableUtils.closeQuietly((Closeable)closeable);
            }
        }
    }

    private String[] toArgsArray(Map<String, String> argsBuilder) {
        ArrayList args = Lists.newArrayList();
        for (Map.Entry<String, String> entry : argsBuilder.entrySet()) {
            args.add(entry.getKey());
            args.add(entry.getValue());
        }
        return args.toArray(new String[args.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> makeArgsBuilder() {
        HashMap argsBuilder = Maps.newHashMap();
        try {
            URL resource = Resources.getResource((String)EXHIBITOR_PROPERTIES);
            InputStream stream = resource.openStream();
            try {
                Properties properties = new Properties(System.getProperties());
                properties.load(stream);
                this.applyProperties(argsBuilder, properties);
            }
            finally {
                CloseableUtils.closeQuietly((Closeable)stream);
            }
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Could not find exhibitor.properties");
        }
        catch (IOException e) {
            this.log.error("Could not load exhibitor.properties", (Throwable)e);
        }
        this.applyProperties(argsBuilder, System.getProperties());
        return argsBuilder;
    }

    private void applyProperties(Map<String, String> argsBuilder, Properties properties) {
        Enumeration<?> parameterNames = properties.propertyNames();
        while (parameterNames.hasMoreElements()) {
            String name = String.valueOf(parameterNames.nextElement());
            if (!name.startsWith(OUR_PREFIX)) continue;
            String value = properties.getProperty(name);
            String argName = name.substring(OUR_PREFIX.length());
            argsBuilder.put("-" + argName, value);
            this.log.info(String.format("Setting property %s=%s", argName, value));
        }
    }
}

