/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.exhibitor.servlet;

import com.netflix.exhibitor.core.Exhibitor;
import com.netflix.exhibitor.core.rest.UIContext;
import com.netflix.exhibitor.core.rest.jersey.JerseySupport;
import com.netflix.exhibitor.servlet.ExhibitorServletContextListener;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorResourceConfig
extends ResourceConfig {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DefaultResourceConfig config;

    public ExhibitorResourceConfig(@Context ServletContext context) {
        DefaultResourceConfig localConfig;
        Exhibitor exhibitor = (Exhibitor)context.getAttribute(ExhibitorServletContextListener.class.getName());
        if (exhibitor != null) {
            this.log.info("Adding Exhibitor Jersey resources");
            localConfig = JerseySupport.newApplicationConfig((UIContext)new UIContext(exhibitor));
        } else {
            this.log.info("Using DefaultResourceConfig");
            localConfig = new DefaultResourceConfig();
        }
        this.config = localConfig;
    }

    public Set<Class<?>> getClasses() {
        return this.config.getClasses();
    }

    public Set<Object> getSingletons() {
        return this.config.getSingletons();
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        return this.config.getMediaTypeMappings();
    }

    public Map<String, String> getLanguageMappings() {
        return this.config.getLanguageMappings();
    }

    public Map<String, Object> getExplicitRootResources() {
        return this.config.getExplicitRootResources();
    }

    public Map<String, Boolean> getFeatures() {
        return this.config.getFeatures();
    }

    public boolean getFeature(String featureName) {
        return this.config.getFeature(featureName);
    }

    public Map<String, Object> getProperties() {
        return this.config.getProperties();
    }

    public Object getProperty(String propertyName) {
        return this.config.getProperty(propertyName);
    }

    public void validate() {
        this.config.validate();
    }

    public Set<Class<?>> getRootResourceClasses() {
        return this.config.getRootResourceClasses();
    }

    public Set<Class<?>> getProviderClasses() {
        return this.config.getProviderClasses();
    }

    public Set<Object> getRootResourceSingletons() {
        return this.config.getRootResourceSingletons();
    }

    public Set<Object> getProviderSingletons() {
        return this.config.getProviderSingletons();
    }

    public List getContainerRequestFilters() {
        return this.config.getContainerRequestFilters();
    }

    public List getContainerResponseFilters() {
        return this.config.getContainerResponseFilters();
    }

    public List getResourceFilterFactories() {
        return this.config.getResourceFilterFactories();
    }

    public void setPropertiesAndFeatures(Map<String, Object> entries) {
        this.config.setPropertiesAndFeatures(entries);
    }

    public void add(Application app) {
        this.config.add(app);
    }

    public ResourceConfig clone() {
        return this.config.clone();
    }
}

