/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.exhibitor.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.exhibitor.core.Exhibitor;
import com.netflix.exhibitor.core.ExhibitorArguments;
import com.netflix.exhibitor.core.RemoteConnectionConfiguration;
import com.netflix.exhibitor.core.backup.BackupProvider;
import com.netflix.exhibitor.core.config.ConfigProvider;
import com.netflix.exhibitor.core.rest.UIContext;
import com.netflix.exhibitor.core.rest.jersey.JerseySupport;
import com.netflix.exhibitor.servlet.ExhibitorServletFilter;
import com.netflix.exhibitor.standalone.ExhibitorCreator;
import com.netflix.exhibitor.standalone.ExhibitorCreatorExit;
import com.netflix.exhibitor.standalone.SecurityArguments;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.curator.utils.CloseableUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorMain
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Server server;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Exhibitor exhibitor;
    private final AtomicBoolean shutdownSignaled = new AtomicBoolean(false);
    private final Map<String, String> users = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ExhibitorCreator creator;
        try {
            creator = new ExhibitorCreator(args);
        }
        catch (ExhibitorCreatorExit exit) {
            if (exit.getError() != null) {
                System.err.println(exit.getError());
            }
            exit.getCli().printHelp();
            return;
        }
        SecurityArguments securityArguments = new SecurityArguments(creator.getSecurityFile(), creator.getRealmSpec(), creator.getRemoteAuthSpec());
        ExhibitorMain exhibitorMain = new ExhibitorMain(creator.getBackupProvider(), creator.getConfigProvider(), creator.getBuilder(), creator.getHttpPort(), creator.getListenAddress(), creator.getSecurityHandler(), securityArguments);
        ExhibitorMain.setShutdown(exhibitorMain);
        try {
            exhibitorMain.start();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println(String.format("Failed to start HTTP server on address %s, port %d. Exiting", creator.getListenAddress(), creator.getHttpPort()));
            Runtime.getRuntime().exit(1);
        }
        try {
            exhibitorMain.join();
        }
        finally {
            exhibitorMain.close();
            for (Closeable closeable : creator.getCloseables()) {
                CloseableUtils.closeQuietly((Closeable)closeable);
            }
        }
    }

    public ExhibitorMain(BackupProvider backupProvider, ConfigProvider configProvider, ExhibitorArguments.Builder builder, int httpPort, String listenAddress, SecurityHandler security, SecurityArguments securityArguments) throws Exception {
        HashUserRealm realm = this.makeRealm(securityArguments);
        if (securityArguments.getRemoteAuthSpec() != null) {
            this.addRemoteAuth(builder, securityArguments.getRemoteAuthSpec());
        }
        builder.shutdownProc(ExhibitorMain.makeShutdownProc(this));
        this.exhibitor = new Exhibitor(configProvider, null, backupProvider, builder.build());
        this.exhibitor.start();
        DefaultResourceConfig application = JerseySupport.newApplicationConfig((UIContext)new UIContext(this.exhibitor));
        ServletContainer container = new ServletContainer((Application)application);
        this.server = new Server();
        SocketConnector http = new SocketConnector();
        http.setHost(listenAddress);
        http.setPort(httpPort);
        this.server.addConnector((Connector)http);
        Context root = new Context((HandlerContainer)this.server, "/", 1);
        root.addFilter(ExhibitorServletFilter.class, "/", 15);
        root.addServlet(new ServletHolder((Servlet)container), "/*");
        if (security != null) {
            root.setSecurityHandler(security);
        } else if (securityArguments.getSecurityFile() != null) {
            this.addSecurityFile(realm, securityArguments.getSecurityFile(), root);
        }
    }

    private void addRemoteAuth(ExhibitorArguments.Builder builder, String remoteAuthSpec) {
        HTTPBasicAuthFilter filter;
        String[] parts = remoteAuthSpec.split(":");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)("Badly formed remote client authorization: " + remoteAuthSpec));
        String type = parts[0].trim();
        String userName = parts[1].trim();
        String password = (String)Preconditions.checkNotNull((Object)this.users.get(userName), (Object)("Realm user not found: " + userName));
        if (type.equals("basic")) {
            filter = new HTTPBasicAuthFilter(userName, password);
        } else if (type.equals("digest")) {
            filter = new HTTPDigestAuthFilter(userName, password);
        } else {
            throw new IllegalStateException("Unknown remote client authorization type: " + type);
        }
        builder.remoteConnectionConfiguration(new RemoteConnectionConfiguration(Arrays.asList(filter)));
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() {
        try {
            while (!this.shutdownSignaled.get() && !Thread.currentThread().isInterrupted()) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.log.info("Shutting down");
            CloseableUtils.closeQuietly((Closeable)this.exhibitor);
            try {
                this.server.stop();
            }
            catch (Exception e) {
                this.log.error("Error shutting down Jetty", (Throwable)e);
            }
            this.server.destroy();
        }
    }

    private static void setShutdown(ExhibitorMain exhibitorMain) {
        Runtime.getRuntime().addShutdownHook(new Thread(ExhibitorMain.makeShutdownProc(exhibitorMain)));
    }

    private static Runnable makeShutdownProc(final ExhibitorMain exhibitorMain) {
        return new Runnable(){

            @Override
            public void run() {
                exhibitorMain.shutdownSignaled.set(true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSecurityFile(HashUserRealm realm, String securityFile, Context root) throws Exception {
        final URL url = new URL("file", null, securityFile);
        final WebXmlConfiguration webXmlConfiguration = new WebXmlConfiguration();
        WebAppContext context = new WebAppContext();
        context.setServer(this.server);
        webXmlConfiguration.setWebAppContext(context);
        ContextHandler contextHandler = new ContextHandler("/"){

            protected void startContext() throws Exception {
                super.startContext();
                this.setServer(ExhibitorMain.this.server);
                webXmlConfiguration.configure(url.toString());
            }
        };
        try {
            SecurityHandler securityHandler = webXmlConfiguration.getWebAppContext().getSecurityHandler();
            if (realm != null) {
                securityHandler.setUserRealm((UserRealm)realm);
            }
            root.setSecurityHandler(securityHandler);
            contextHandler.start();
        }
        finally {
            contextHandler.stop();
        }
    }

    private HashUserRealm makeRealm(SecurityArguments securityArguments) throws Exception {
        if (securityArguments.getRealmSpec() == null) {
            return null;
        }
        String[] parts = securityArguments.getRealmSpec().split(":");
        if (parts.length != 2) {
            throw new Exception("Bad realm spec: " + securityArguments.getRealmSpec());
        }
        return new HashUserRealm(parts[0].trim(), parts[1].trim()){

            public Object put(Object name, Object credentials) {
                ExhibitorMain.this.users.put(String.valueOf(name), String.valueOf(credentials));
                return super.put(name, credentials);
            }
        };
    }
}

