/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.microprofile;

import io.smallrye.stork.config.ConfigProvider;
import io.smallrye.stork.config.LoadBalancerConfig;
import io.smallrye.stork.config.ServiceConfig;
import io.smallrye.stork.config.ServiceDiscoveryConfig;
import io.smallrye.stork.spi.SimpleServiceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class MicroProfileConfigProvider
implements ConfigProvider {
    private static final Logger log = Logger.getLogger(MicroProfileConfigProvider.class);
    public static final String LOAD_BALANCER = "load-balancer";
    public static final String SERVICE_DISCOVERY = "service-discovery";
    private final List<ServiceConfig> serviceConfigs = new ArrayList<ServiceConfig>();

    public MicroProfileConfigProvider() {
        Config config = org.eclipse.microprofile.config.ConfigProvider.getConfig();
        HashMap<String, Map> propertiesByServiceName = new HashMap<String, Map>();
        for (String string : config.getPropertyNames()) {
            String[] property = string.split("\\.");
            if (property.length < 1 || !property[0].equals("stork")) continue;
            if (property.length < 3) {
                log.warn((Object)("Potentially invalid property for SmallRye Stork: " + string));
            }
            String serviceName = property[1];
            Map serviceProperties = propertiesByServiceName.computeIfAbsent(serviceName, ignored -> new HashMap());
            serviceProperties.put(string.substring(property[0].length() + property[1].length() + 2), (String)config.getValue(string, String.class));
        }
        for (Map.Entry entry : propertiesByServiceName.entrySet()) {
            String serviceDiscoveryType;
            SimpleServiceConfig.Builder builder = new SimpleServiceConfig.Builder();
            Map properties = (Map)entry.getValue();
            String loadBalancerType = (String)properties.get(LOAD_BALANCER);
            builder.setServiceName((String)entry.getKey());
            if (loadBalancerType != null) {
                SimpleServiceConfig.SimpleLoadBalancerConfig loadBalancer = new SimpleServiceConfig.SimpleLoadBalancerConfig(loadBalancerType, this.propertiesForPrefix(LOAD_BALANCER, properties));
                builder = builder.setLoadBalancer((LoadBalancerConfig)loadBalancer);
            }
            if ((serviceDiscoveryType = (String)properties.get(SERVICE_DISCOVERY)) != null) {
                SimpleServiceConfig.SimpleServiceDiscoveryConfig serviceDiscovery = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceDiscoveryType, this.propertiesForPrefix(SERVICE_DISCOVERY, properties));
                builder = builder.setServiceDiscovery((ServiceDiscoveryConfig)serviceDiscovery);
            }
            this.serviceConfigs.add((ServiceConfig)builder.build());
        }
    }

    private Map<String, String> propertiesForPrefix(String prefix, Map<String, String> original) {
        prefix = ((String)prefix).endsWith(".") ? prefix : (String)prefix + ".";
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith((String)prefix)) continue;
            String nameWithoutPrefix = propertyName.substring(((String)prefix).length());
            result.put(nameWithoutPrefix, entry.getValue());
        }
        return result;
    }

    public List<ServiceConfig> getConfigs() {
        return this.serviceConfigs;
    }

    public int priority() {
        return 100;
    }
}

