/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.internal.models.media.SchemaSupport;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.RequirementHandler;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.Type;

public class AnnotationTargetProcessor
implements RequirementHandler {
    private final AnnotationScannerContext context;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final Type entityType;
    private final AnnotationTarget annotationTarget;
    private static final List<Function<Schema, Object>> SCHEMA_ASSERTION_PROVIDERS = Arrays.asList(Schema::getAdditionalPropertiesSchema, Schema::getAllOf, Schema::getAnyOf, Schema::getDiscriminator, Schema::getEnumeration, Schema::getExclusiveMaximum, Schema::getExclusiveMinimum, Schema::getFormat, Schema::getItems, Schema::getMaximum, Schema::getMaxItems, Schema::getMaxLength, Schema::getMaxProperties, Schema::getMinimum, Schema::getMinItems, Schema::getMinLength, Schema::getMinProperties, Schema::getMultipleOf, Schema::getNot, Schema::getOneOf, Schema::getPattern, Schema::getProperties, Reference::getRef, Schema::getRequired, Schema::getUniqueItems, Schema::getXml);
    private static final List<Function<Schema, Object>> SCHEMA_ANNOTATION_PROVIDERS = Arrays.asList(Schema::getDefaultValue, Schema::getDeprecated, Schema::getDescription, Schema::getExample, Schema::getExamples, Extensible::getExtensions, Schema::getExternalDocs, Schema::getReadOnly, Schema::getTitle, Schema::getWriteOnly);

    private AnnotationTargetProcessor(AnnotationScannerContext context, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, Type entityType) {
        this.context = context;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, typeResolver.getAnnotationTarget(), typeResolver.getUnresolvedType());
        return fp.processField();
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, (AnnotationTarget)context.getAugmentedIndex().getClass(type), type);
        return fp.processField();
    }

    @Override
    public void setRequired(AnnotationTarget target, String propertyKey) {
        AnnotationInstance schemaAnnotation;
        List requiredProperties = this.parentPathEntry.getSchema().getRequired();
        if (!(requiredProperties != null && requiredProperties.contains(propertyKey) || (schemaAnnotation = TypeUtil.getSchemaAnnotation(this.context, target)) != null && schemaAnnotation.value("required") != null)) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
    }

    Schema processField() {
        boolean registrationCandidate;
        Type registrationType;
        Type fieldType;
        Schema typeSchema;
        TypeProcessor typeProcessor;
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.context, this.annotationTarget);
        String propertyKey = this.typeResolver.getPropertyName();
        SchemaRegistry schemaRegistry = this.context.getSchemaRegistry();
        if (schemaAnnotation != null && JandexUtil.hasImplementation(schemaAnnotation)) {
            typeProcessor = null;
            typeSchema = null;
            fieldType = (Type)this.context.annotations().value(schemaAnnotation, "implementation");
            registrationType = null;
            registrationCandidate = false;
        } else {
            typeProcessor = new TypeProcessor(this.context, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, OASFactory.createSchema(), this.annotationTarget);
            fieldType = typeProcessor.processType();
            Schema initTypeSchema = typeProcessor.getSchema();
            if (!TypeUtil.isTypeOverridden(this.context, fieldType, schemaAnnotation)) {
                TypeUtil.applyTypeAttributes(fieldType, initTypeSchema, schemaAnnotation);
            }
            registrationType = TypeUtil.isWrappedType(this.entityType) ? fieldType : this.entityType;
            registrationCandidate = !JandexUtil.isRef(schemaAnnotation) && typeProcessor.allowRegistration() && schemaRegistry.register(registrationType, this.context.getJsonViews(), this.typeResolver, initTypeSchema, (reg, key) -> null) != initTypeSchema;
            typeSchema = registrationCandidate && schemaRegistry.hasSchema(registrationType, this.context.getJsonViews(), this.typeResolver) ? schemaRegistry.lookupSchema(TypeResolver.resolve(registrationType, this.typeResolver), this.context.getJsonViews()) : initTypeSchema;
        }
        Schema fieldSchema = schemaAnnotation != null ? this.readSchemaAnnotatedField(propertyKey, schemaAnnotation, fieldType) : (registrationCandidate ? OASFactory.createSchema().type(typeSchema.getType()) : (Schema)MergeUtil.mergeObjects(OASFactory.createSchema(), typeSchema));
        this.context.getKotlinMetadataScanner().applyMetadata(this.annotationTarget, fieldSchema, propertyKey, this);
        Optional<BeanValidationScanner> constraintScanner = this.context.getBeanValidationScanner();
        if (constraintScanner.isPresent()) {
            for (AnnotationTarget contraintTarget : this.typeResolver.getConstraintTargets()) {
                constraintScanner.get().applyConstraints(contraintTarget, fieldSchema, propertyKey, (RequirementHandler)this);
            }
        }
        if (SchemaSupport.getNullable(fieldSchema) == null && TypeUtil.isOptional(this.entityType)) {
            SchemaSupport.setNullable(fieldSchema, Boolean.TRUE);
        }
        if (fieldSchema.getReadOnly() == null && this.typeResolver.isReadOnly()) {
            fieldSchema.setReadOnly(Boolean.TRUE);
        }
        if (fieldSchema.getWriteOnly() == null && this.typeResolver.isWriteOnly()) {
            fieldSchema.setWriteOnly(Boolean.TRUE);
        }
        TypeUtil.mapDeprecated(this.context, this.annotationTarget, () -> ((Schema)fieldSchema).getDeprecated(), arg_0 -> ((Schema)fieldSchema).setDeprecated(arg_0));
        this.processFieldAnnotations(fieldSchema, this.typeResolver);
        Schema parentSchema = this.parentPathEntry.getSchema();
        Schema existingFieldSchema = ModelUtil.getPropertySchema(parentSchema, propertyKey);
        if (existingFieldSchema != null) {
            fieldSchema = MergeUtil.mergeObjects(fieldSchema, existingFieldSchema);
        }
        if (registrationCandidate) {
            if (this.fieldAssertionConflicts(fieldSchema, typeSchema)) {
                List declaredType = Optional.ofNullable(fieldSchema.getType()).orElseGet(Collections::emptyList);
                fieldSchema = SchemaFactory.includeTypeSchema(this.context, fieldSchema, fieldType, declaredType);
            } else {
                typeProcessor.pushObjectStackInput();
                List typeList = typeSchema.getType();
                Schema registeredTypeSchema = typeList != null && !typeList.contains(Schema.SchemaType.ARRAY) ? schemaRegistry.registerReference(registrationType, this.context.getJsonViews(), this.typeResolver, typeSchema) : schemaRegistry.checkRegistration(registrationType, this.context.getJsonViews(), this.typeResolver, typeSchema);
                boolean fieldSchemaNullable = this.isNullable(fieldSchema);
                if (fieldSchema.getRef() == null && (this.fieldAssertionsOverrideType(fieldSchema, typeSchema) || this.fieldSpecifiesAnnotation(fieldSchema))) {
                    TypeUtil.clearMatchingDefaultAttributes(fieldSchema, typeSchema);
                    fieldSchema.setRef(registeredTypeSchema.getRef());
                    SchemaSupport.addTypeObserver(typeSchema, fieldSchema);
                } else {
                    fieldSchema = registeredTypeSchema;
                }
                if (fieldSchemaNullable && !this.isNullable(typeSchema)) {
                    Schema refSchema = (Schema)OASFactory.createSchema().ref(fieldSchema.getRef());
                    fieldSchema.setRef(null);
                    if (fieldSchema.getAnyOf() == null) {
                        fieldSchema.addAnyOf(refSchema).addAnyOf(SchemaSupport.nullSchema());
                    } else {
                        Schema anyOfSchema = OASFactory.createSchema().addAnyOf(refSchema).addAnyOf(SchemaSupport.nullSchema());
                        fieldSchema.addAllOf(anyOfSchema);
                    }
                }
            }
        } else if (!JandexUtil.isRef(schemaAnnotation)) {
            if (typeProcessor != null) {
                typeProcessor.pushObjectStackInput();
            }
            fieldSchema = MergeUtil.mergeObjects(typeSchema, fieldSchema);
        }
        parentSchema.addProperty(propertyKey, fieldSchema);
        return fieldSchema;
    }

    private boolean isNullable(Schema schema) {
        return Boolean.TRUE.equals(SchemaSupport.getNullable(schema));
    }

    private void processFieldAnnotations(Schema fieldSchema, TypeResolver typeResolver) {
        AnnotationTarget target;
        String name = typeResolver.getBeanPropertyName();
        Iterator<Declaration> iterator = Arrays.asList(typeResolver.getField(), typeResolver.getReadMethod(), typeResolver.getWriteMethod()).iterator();
        while (iterator.hasNext() && ((target = (AnnotationTarget)iterator.next()) == null || !this.processXmlAttr(name, fieldSchema, target))) {
        }
    }

    private boolean processXmlAttr(String name, Schema fieldSchema, AnnotationTarget target) {
        AnnotationInstance xmlAttr = this.context.annotations().getAnnotation(target, JaxbConstants.XML_ATTRIBUTE);
        AnnotationInstance xmlElement = this.context.annotations().getAnnotation(target, JaxbConstants.XML_ELEMENT);
        AnnotationInstance xmlWrapper = this.context.annotations().getAnnotation(target, JaxbConstants.XML_WRAPPERELEMENT);
        if (xmlAttr == null && xmlWrapper == null && xmlElement == null) {
            return false;
        }
        if (xmlAttr != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().attribute(Boolean.valueOf(true));
            this.setXmlName(fieldSchema, name, xmlAttr);
        }
        if (xmlWrapper != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().wrapped(Boolean.valueOf(true));
            this.setXmlName(fieldSchema, name, xmlWrapper);
            if (xmlElement != null) {
                this.setXmlName(fieldSchema.getItems(), name, xmlElement);
                return true;
            }
        }
        if (xmlElement != null) {
            this.setXmlName(fieldSchema, name, xmlElement);
        }
        return true;
    }

    private void setXmlIfEmpty(Schema schema) {
        if (schema.getXml() != null) {
            return;
        }
        schema.setXml(OASFactory.createXML());
    }

    private void setXmlName(Schema fieldSchema, String realName, AnnotationInstance xmlAttr) {
        String annName;
        AnnotationValue name = xmlAttr.value("name");
        if (fieldSchema != null && name != null && !(annName = name.asString()).equals(realName)) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().name(annName);
        }
    }

    private Schema readSchemaAnnotatedField(String propertyKey, AnnotationInstance annotation, Type postProcessedField) {
        DataObjectLogging.logger.processingFieldAnnotation(annotation, propertyKey);
        if (this.context.annotations().value(annotation, "required", Boolean.FALSE).booleanValue()) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        Map<String, Object> defaults = JandexUtil.isBooleanSchema(annotation) || JandexUtil.isArraySchema(this.context, annotation) || TypeUtil.isTypeOverridden(this.context, postProcessedField, annotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(postProcessedField);
        return SchemaFactory.readSchema(this.context, OASFactory.createSchema(), annotation, defaults);
    }

    boolean fieldAssertionConflicts(Schema fieldSchema, Schema typeSchema) {
        return SCHEMA_ASSERTION_PROVIDERS.stream().map(provider -> {
            Object typeAttr;
            Object fieldAttr = provider.apply(fieldSchema);
            if (fieldAttr != null && (typeAttr = provider.apply(typeSchema)) != null && !fieldAttr.equals(typeAttr)) {
                return true;
            }
            return false;
        }).anyMatch(Boolean.TRUE::equals);
    }

    boolean fieldAssertionsOverrideType(Schema fieldSchema, Schema typeSchema) {
        return SCHEMA_ASSERTION_PROVIDERS.stream().map(provider -> {
            Object fieldAttr = provider.apply(fieldSchema);
            if (fieldAttr != null) {
                return !fieldAttr.equals(provider.apply(typeSchema));
            }
            return false;
        }).anyMatch(Boolean.TRUE::equals);
    }

    boolean fieldSpecifiesAnnotation(Schema fieldSchema) {
        for (Function<Schema, Object> provider : SCHEMA_ANNOTATION_PROVIDERS) {
            if (provider.apply(fieldSchema) == null) continue;
            return true;
        }
        return false;
    }
}

