/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.jaxrs;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

public class JaxRsMetricsFilter
implements ContainerRequestFilter {
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        MetricID metricID = this.getMetricID(this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod());
        requestContext.setProperty("smallrye.metrics.jaxrs.metricID", (Object)metricID);
    }

    private MetricID getMetricID(Class<?> resourceClass, Method resourceMethod) {
        Tag classTag = new Tag("class", resourceClass.getName());
        String methodName = resourceMethod.getName();
        String encodedParameterNames = Arrays.stream(resourceMethod.getParameterTypes()).map(clazz -> {
            if (clazz.isArray()) {
                return clazz.getComponentType().getName() + "[]";
            }
            return clazz.getName();
        }).collect(Collectors.joining("_"));
        String methodTagValue = encodedParameterNames.isEmpty() ? methodName : methodName + "_" + encodedParameterNames;
        Tag methodTag = new Tag("method", methodTagValue);
        return new MetricID("REST.request", new Tag[]{classTag, methodTag});
    }
}

