/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class JsonMetadataExporter
implements Exporter {
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        MetricRegistry registry = MetricRegistries.get(scope);
        if (registry == null) {
            return null;
        }
        JsonObject obj = this.registryJSON(registry);
        return this.stringify(obj);
    }

    @Override
    public StringBuilder exportAllScopes() {
        JsonObject obj = this.rootJSON();
        return this.stringify(obj);
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        throw new UnsupportedOperationException("Exporting metadata of one metricID is currently not implemented because it is not possible to perform such export according to specification.");
    }

    @Override
    public StringBuilder exportMetricsByName(MetricRegistry.Type scope, String name) {
        MetricRegistry registry = MetricRegistries.get(scope);
        if (registry == null) {
            return null;
        }
        Metadata metadata = (Metadata)registry.getMetadata().get(name);
        if (metadata == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.metricJSON(builder, name, metadata, this.getKnownTagsByMetricName(registry, name));
        return this.stringify(builder.build());
    }

    StringBuilder stringify(JsonObject obj) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = Json.createWriterFactory(JSON_CONFIG).createWriter((Writer)out);){
            writer.writeObject(obj);
        }
        return new StringBuilder(out.toString());
    }

    private JsonObject rootJSON() {
        JsonObjectBuilder root = Json.createObjectBuilder();
        root.add("base", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.BASE)));
        root.add("vendor", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.VENDOR)));
        root.add("application", (JsonValue)this.registryJSON(MetricRegistries.get(MetricRegistry.Type.APPLICATION)));
        return root.build();
    }

    private JsonObject registryJSON(MetricRegistry registry) {
        JsonObjectBuilder registryJSON = Json.createObjectBuilder();
        Map metrics = registry.getMetadata();
        metrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> this.metricJSON(registryJSON, (String)e.getKey(), (Metadata)e.getValue(), this.getKnownTagsByMetricName(registry, (String)e.getKey())));
        return registryJSON.build();
    }

    private void metricJSON(JsonObjectBuilder registryJSON, String name, Metadata metric, List<List<String>> tagSets) {
        registryJSON.add(name, (JsonValue)this.metricJSON(metric, tagSets));
    }

    private JsonObject metricJSON(Metadata metadata, List<List<String>> tagSets) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        metadata.getUnit().ifPresent(s -> obj.add("unit", s));
        if (metadata.getType() != null) {
            obj.add("type", metadata.getType());
        }
        metadata.getDescription().ifPresent(s -> obj.add("description", s));
        if (metadata.getDisplayName() != null) {
            obj.add("displayName", metadata.getDisplayName());
        }
        JsonArrayBuilder tagsArray = Json.createArrayBuilder();
        tagSets.forEach(tagSet -> {
            JsonArrayBuilder innerArrayBuilder = Json.createArrayBuilder();
            tagSet.forEach(arg_0 -> ((JsonArrayBuilder)innerArrayBuilder).add(arg_0));
            tagsArray.add(innerArrayBuilder);
        });
        obj.add("tags", tagsArray);
        return obj.build();
    }

    private List<List<String>> getKnownTagsByMetricName(MetricRegistry registry, String name) {
        return registry.getMetricIDs().stream().filter(id -> id.getName().equals(name)).map(id -> id.getTagsAsList().stream().map(tag -> tag.getTagName() + "=" + tag.getTagValue()).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

