/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.internal.InternalLogger;
import jakarta.enterprise.context.control.RequestContextController;

public class RequestScopeActivator<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final RequestContextController requestContextController;

    public RequestScopeActivator(FaultToleranceStrategy<V> delegate, RequestContextController requestContextController) {
        this.delegate = delegate;
        this.requestContextController = requestContextController;
    }

    public Future<V> apply(FaultToleranceContext<V> ctx) {
        InternalLogger.LOG.trace("RequestScopeActivator started");
        try {
            this.requestContextController.activate();
            Future future = this.delegate.apply(ctx);
            return future;
        }
        finally {
            this.requestContextController.deactivate();
            InternalLogger.LOG.trace("RequestScopeActivator finished");
        }
    }
}

