package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;

/**
 * Automatically generated from the {@link BeforeRetryConfig} config interface, do not modify.
 */
public final class BeforeRetryConfigImpl implements BeforeRetryConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final BeforeRetry instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code BeforeRetry.value} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends BeforeRetryHandler> _value;

    /**
     * Cached value of the {@code BeforeRetry.methodName} annotation member; {@code null} if not looked up yet.
     */
    private String _methodName;

    private BeforeRetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.beforeRetry;
        this.onMethod = method.annotationsPresentDirectly.contains(BeforeRetry.class);
    }

    public static BeforeRetryConfigImpl create(FaultToleranceMethod method) {
        if (method.beforeRetry == null) {
            return null;
        }
        if (!Config.isEnabled(BeforeRetry.class, method.method)) {
            return null;
        }
        return new BeforeRetryConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return BeforeRetry.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<? extends BeforeRetryHandler> value() {
        if (_value == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/BeforeRetry/value";
                _value = config.getOptionalValue(key, Class.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/BeforeRetry/value";
                _value = config.getOptionalValue(key, Class.class).orElse(null);
            }
            if (_value == null) {
                // <annotation>/<parameter>
                _value = config.getOptionalValue("BeforeRetry/value", Class.class).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public String methodName() {
        if (_methodName == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/BeforeRetry/methodName";
                _methodName = config.getOptionalValue(key, String.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/BeforeRetry/methodName";
                _methodName = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (_methodName == null) {
                // <annotation>/<parameter>
                _methodName = config.getOptionalValue("BeforeRetry/methodName", String.class).orElse(null);
            }
            if (_methodName == null) {
                // annotation value
                _methodName = instance.methodName();
            }
        }
        return _methodName;
    }

    @Override
    public void materialize() {
        value();
        methodName();
    }
}
